var Mover = cc.Class({
    name: 'Mover',
    extends: cc.Object,
    properties: {
        node: {
            default: null,
            type: cc.Node,
        },
    },
   
    ctor: function (node) {
        this.node = node; 
    },

    moveRight: function (distance) {
        var self = this;
        if (!self.node) {
            cc.warn("No node!");
            return;
        }

        var duration = Math.abs(distance) / 128;
        self.node.runAction(cc.moveBy(duration, cc.p(distance, self.node.y)));
    },
    
    moveLeft: function (distance) {
        this.moveRight(-distance);
    },
    
    moveTo: function (dist, postProcessor) {
        var self = this;
        if (!self.node) {
            cc.warn("No node!");
            return;
        }

        var distance = Math.abs(dist.x - self.node.x);
        var duration = distance / 128;
        self.node.runAction(cc.sequence(
            cc.moveTo(duration, cc.p(dist.x, self.node.y)),
            postProcessor));
    },
    
});

module.exports = Mover; 
