cc.Class({
    extends: cc.Component,

    properties: {
        bgNode: cc.Node,//背景层
        maskNode: cc.Node,//遮罩层
        _eraser: null,//橡皮擦
        _renderTexture: null,//画板
        _isInit: false,//是否初始化
        radius: cc.Integer,//橡皮擦半径
        ignore: cc.Integer,//判断擦除完毕时忽略的层数
        interval: cc.Float,//清除动画间隔时间,单位是秒
        _objList: null,//存放逻辑判断矩形信息
        _allList: null,//记录所有矩形信息
    },

    // use this for initialization
    onLoad: function () {
        let self = this;
        self._objList = [];
        self._allList = [];
        //切割获取矩形信息
        let box = self.bgNode.getBoundingBox();
        let wCount = Math.floor(box.width / self.radius / 2);
        let hCount = Math.floor(box.height / self.radius / 2);
        for (let x = 0; x <= wCount; x++) {
            for (let y = 0; y <= hCount; y++) {
                let startX = box.x + x * 2 * self.radius;
                let startY = box.y + y * 2 * self.radius;
                let rect = new cc.rect(startX, startY, 2 * self.radius, 2 * self.radius);
                if (x >= self.ignore && y >= self.ignore && x <= wCount - self.ignore && y <= hCount - self.ignore) {
                    let obj = { "rect": rect, "isMove": false };
                    self._objList.push(obj);
                }
                let allX = x * 2 * self.radius;
                let allY = y * 2 * self.radius;
                let allRect = new cc.rect(allX, allY, 2 * self.radius, 2 * self.radius);
                self._allList.push(allRect);
            }
        }
    },

    lateUpdate: function (dt) {
        if (!this._isInit) {
            this.init();
        }
    },

    init: function () {
        let self = this;
        self._isInit = true;
        //创建和需要显示的图片大小一样的rendertexture
        self._renderTexture = cc.RenderTexture.create(self.bgNode.width, self.bgNode.height, cc.Texture2D.PIXEL_FORMAT_RGBA8888, gl.DEPTH24_STENCIL8_OES);
        //rendertexture的锚点是在(0,0),所有需要重新定义遮罩层的坐标
        self.maskNode.setPosition(cc.p(self.bgNode.width / 2, self.bgNode.height / 2));
        //把rendertexture添加到背景层的gl节点上
        self.bgNode._sgNode.addChild(self._renderTexture);
        //先渲染上遮罩层
        self._renderTexture.begin();
        self.maskNode._sgNode.visit();
        self._renderTexture.end();
        //移除遮罩节点（因为visit之后不需要原始节点了）
        self.maskNode.destroy();
        //创建橡皮擦
        self._eraser = new cc.DrawNode();
        //绑定滑动事件
        self.bgNode.on(cc.Node.EventType.TOUCH_MOVE, self.touchMoved, self);
        //绑定滑动结束事件
        self.bgNode.on(cc.Node.EventType.TOUCH_END, self.touchEnd, self);
    },

    touchMoved: function (event) {
        let self = this;
        let touch = event.touch.getLocation();
        let target = event.getCurrentTarget();
        let point = target.convertToNodeSpaceAR(touch);
        let box = self.bgNode.getBoundingBox();
        if (box.contains(point)) {
            self._eraser.drawDot(cc.p(box.width / 2 + point.x, box.height / 2 + point.y), self.radius, cc.color(0, 0, 0, 255));
            //这一步最重要，选择透明之外的部分，也就是画的圆，将渲染入的底图，也就是遮罩层，以透明方式融合，形成一个有洞的遮罩层。
            self._eraser.setBlendFunc({ 'src': cc.ZERO, 'dst': cc.ONEMINUSSRC_ALPHA });
            self._renderTexture.begin();
            self._eraser.visit();
            self._renderTexture.end();
            self.checkMove(point);
        }
    },

    touchEnd: function () {
        this.checkEnd();
    },
    //判断点是否在逻辑矩形中
    checkMove: function (point) {
        let self = this;
        for (let i = 0; i < self._objList.length; i++) {
            let obj = self._objList[i];
            if (!obj.isMove) {
                if (obj.rect.contains(point)) {
                    obj.isMove = true;
                    break;
                }
            }
        }
    },
    //检查所有矩形都滑动到了
    checkEnd: function () {
        let self = this;
        let moveAll = true;
        for (let i = 0; i < self._objList.length; i++) {
            let obj = self._objList[i];
            if (!obj.isMove) {
                moveAll = false;
                break;
            }
        }
        if (moveAll) {//擦除结束
            self.bgNode.off(cc.Node.EventType.TOUCH_MOVE, self.touchMoved, self);
            self.bgNode.off(cc.Node.EventType.TOUCH_END, self.touchEnd, self);

            self.count = 0;
            self.callback = function () {
                let rect = self._allList[self.count];
                self._eraser.drawRect(cc.p(rect.x, rect.y), cc.p(rect.width, rect.height), cc.color(0, 0, 0, 255), 1, cc.color(0, 0, 0, 255));
                //这一步最重要，选择透明之外的部分，也就是画的圆，将渲染入的底图，也就是遮罩层，以透明方式融合，形成一个有洞的遮罩层。
                self._eraser.setBlendFunc({ 'src': cc.ZERO, 'dst': cc.ONEMINUSSRC_ALPHA });
                self._renderTexture.begin();
                self._eraser.visit();
                self._renderTexture.end();
                if (self.count >= self._allList.length - 1) {
                    self.unschedule(self.callback);
                    self._renderTexture.removeFromParent();
                    cc.log("执行完毕！");
                }
                self.count++;
                cc.log(self.count);
            }
            self.schedule(self.callback, self.interval);
        }
    },
});
