let requestCount = 0;

function get(url, onNext, onError) {
    let xhr = new XMLHttpRequest();
    let id = requestCount++;
    xhr.timeout = 10000;
    xhr.onload = () => {
        if (xhr.status >= 200 && xhr.status < 300) {
            onNext(xhr.response);
        } else {
            onError(new Error(`request[${id}] url: ${url} failed, ${xhr.statusText}`));
        }
    };
    xhr.onerror = () => {
        onError(new Error(`request[${id}] url: ${url} failed, network error`));
    };
    xhr.ontimeout = () => {
        onError(new Error(`request[${id}] url: ${url} failed, time out`));
    };

    cc.log(`start request: ${id}`);
    xhr.open('GET', url, true);
    xhr.send();

    return () => xhr.abort();
}

cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function () {
        this.label.string = this.text;

        let request;
        let g204 = 'http://www.gstatic.com/generate_204';
        let onNext = response => {
            cc.log(`response: ${response}`); 
            setTimeout(request, 1000);
        };
        let onError = error => {
            cc.error(`error: ${error}`); 
            setTimeout(request, 1000);
        };
        request = get.bind(null, g204, onNext, onError);

        setTimeout(request, 0);
    },

    // called every frame
    //update: function (dt) {
    //
    //},
});
