
var option = cc.Class({
    name: "Option",
    properties: {
        index:0
    }
})

cc.Class({
    extends: cc.Component,

    properties: {
        prefab: cc.Prefab,
        indexs: {
            default: [],
            type: cc.Integer
        },
        label: cc.Label
    },

    // use this for initialization
    onLoad: function () {
        this.allOption = [];
        this.node.on("pressed", this.switchRadio, this);
        for(let i = 0; i < this.indexs.length; i++){
            var op = cc.instantiate(this.prefab).getComponent("option");
            op.init(i);
            op.node.setPosition(0, 0);
            this.node.addChild(op.node);
            this.allOption.push(op);
        }
       
    },
    
    switchRadio: function (event) {
        var index = event.target.getComponent("option").index;
        this.label.string = "selected " + index;
        for(let i = 0; i < this.allOption.length; i++){
            if(this.allOption[i].index === index){
                this.allOption[i].pitchOn();
            }else{
                this.allOption[i].lifeUp();
            }
        }
    }

    // called every frame, uncomment this function to activate update callback
    // update: function (dt) {

    // },
});
