cc.Class({
    extends: cc.Component,

    properties: {
        boomPre: {default: null, displayName: "炸弹预制体", type: cc.Prefab},
		uiNode: {default: null, displayName: "界面节点", type: cc.Node},
    },

    // use this for initialization
    onLoad: function () {

    },
	onShowUI(){
		this.uiNode.active = !this.uiNode.active;
	},
	onClickBoom(){
		this.schedule(this.createBoom,0.2);
	},
	onClickUnBoom(){
		this.unschedule(this.createBoom);
	},
	createBoom(){
		var clone = cc.instantiate(this.boomPre);
        var script = clone.getComponent("Boom");
		if (script) {
            var ani = script.onBoom();

            var delayTime = new cc.delayTime(ani.duration);
            var removeSelf = new cc.removeSelf(true);
            var callFunc = new cc.CallFunc(function () {
                console.log("remove");
            });
            var seq = new cc.sequence([delayTime, removeSelf, callFunc]);
            clone.runAction(seq);

        }
		this.node.addChild(clone);
	},
	gotoOtherScene(){
		cc.director.loadScene("OtherScene");
	},
    // called every frame, uncomment this function to activate update callback
    // update: function (dt) {

    // },
});
