cc.Class({
    extends: cc.Component,

    properties: {
        BoxBarPrefab: cc.Prefab,
        Speed: 2,
        
    },

    
    onLoad: function () {
        cc.director.getCollisionManager().enabled = true;
        cc.director.getCollisionManager().enabledDebugDraw = true;
         this._pool = new cc.NodePool();
        let i = 10;
        for (let j=0; i<j; ++j) {
        var bar = cc.instantiate(this.BoxBarPrefab); 
        this._pool.put(bar);
    };
    this.spawnbar();

    },

    onCollisionExit: function () {
        this.spawnbar(); 

    },

     spawnbar: function () {
        var bar = this._pool.get();
        if (!bar) {
            bar = cc.instantiate(this.BoxBarPrefab);
        };
        this.node.addChild(bar);
        bar.setPosition(-550,0);
   
        bar.runAction(cc.sequence(
            cc.moveTo(this.Speed, 550, 0),
            cc.callFunc(this.putNode, this, bar)
        )); 
    },

      putNode: function (sender, bar) {
        this._pool.put(bar);
    },

      speedUp: function () {
        this.Speed += 0.5
    },

     speedDown: function () {
         this.Speed -= 0.5
         if(this.Speed<=0){
            this.Speed=0.5
        }
    },

     returnHome: function () {
    cc.director.loadScene('helloworld');
    },


});
