cc.Class({
    'extends': cc.Component,

    properties: {
        BoxBarPrefab: cc.Prefab,
        Speed: 2

    },

    onLoad: function onLoad() {
        cc.director.getCollisionManager().enabled = true;
        cc.director.getCollisionManager().enabledDebugDraw = true;
        this._pool = new cc.NodePool();
        var i = 10;
        for (var j = 0; i < j; ++j) {
            var bar = cc.instantiate(this.BoxBarPrefab);
            this._pool.put(bar);
        };
        this.spawnbar();
    },

    onCollisionExit: function onCollisionExit() {
        this.spawnbar();
    },

    spawnbar: function spawnbar() {
        var bar = this._pool.get();
        if (!bar) {
            bar = cc.instantiate(this.BoxBarPrefab);
        };
        this.node.addChild(bar);
        bar.setPosition(-550, 0);

        bar.runAction(cc.sequence(cc.moveTo(this.Speed, 550, 0), cc.callFunc(this.putNode, this, bar)));
    },

    putNode: function putNode(sender, bar) {
        this._pool.put(bar);
    },

    speedUp: function speedUp() {
        this.Speed += 0.5;
    },

    speedDown: function speedDown() {
        this.Speed -= 0.5;
        if (this.Speed <= 0) {
            this.Speed = 0.5;
        }
    },

    returnHome: function returnHome() {
        cc.director.loadScene('helloworld');
    }

});