cc.Class({
    'extends': cc.Component,

    properties: {
        BarPrefab: cc.Prefab,
        Time: 0.3,
        Speed: 2
    },

    onLoad: function onLoad() {
        this._pool = new cc.NodePool();
        var i = 10;
        for (var j = 0; i < j; ++j) {
            var bar = cc.instantiate(this.BarPrefab);
            this._pool.put(bar);
        };
        this.schedule(this.addBar, 0.3);
    },

    addBar: function addBar() {
        var bar = this._pool.get();
        if (!bar) {
            bar = cc.instantiate(this.BarPrefab);
        };

        bar.setPosition(-550, 0);

        bar.runAction(cc.sequence(cc.moveTo(this.Speed, 550, 0), cc.callFunc(this.putNode, this, bar)));

        this.node.addChild(bar);
    },

    putNode: function putNode(sender, bar) {
        this._pool.put(bar);
    },

    speedUp: function speedUp() {
        this.Speed += 0.5;
    },

    speedDown: function speedDown() {
        this.Speed -= 0.5;
        if (this.Speed <= 0) {
            this.Speed = 0.5;
        }
    },

    returnHome: function returnHome() {
        cc.director.loadScene('helloworld');
    }

});