cc.Class({
    "extends": cc.Component,

    properties: {
        // foo: {
        //    default: null,      // The default value will be used only when the component attaching
        //                           to a node for the first time
        //    url: cc.Texture2D,  // optional, default is typeof default
        //    serializable: true, // optional, default is true
        //    visible: true,      // optional, default is true
        //    displayName: 'Foo', // optional
        //    readonly: false,    // optional, default is false
        // },
        // ...
        jumpDuration: 0,
        jumpHeight: 0,
        accel: 0,
        maxMoveSpeed: 0
    },

    setJump: function setJump() {
        var jumpAction = cc.jumpBy(this.jumpDuration, cc.p(0, 0), this.jumpHeight, 1);
        this.node.runAction(jumpAction);
    },

    setInputControl: function setInputControl() {
        var self = this;
        cc.eventManager.addListener({
            event: cc.EventListener.KEYBOARD,
            onKeyPressed: function onKeyPressed(keyCode, event) {
                switch (keyCode) {
                    case cc.KEY.a:
                        self.accLeft = true;
                        self.accRight = false;
                        break;
                    case cc.KEY.d:
                        self.accLeft = false;
                        self.accRight = true;
                        break;
                    case cc.KEY.space:
                        self.wthJump = true;
                        break;
                }
            },
            onKeyReleased: function onKeyReleased(keyCode, event) {
                switch (keyCode) {
                    case cc.KEY.a:
                        self.accLeft = false;
                        break;
                    case cc.KEY.d:
                        self.accRight = false;
                        break;
                    case cc.KEY.space:
                        self.wthJump = false;
                        break;
                }
            }

        }, this.node);
    },
    // use this for initialization
    onLoad: function onLoad() {
        this.accRight = false;
        this.accLeft = false;
        this.wthJump = false;
        this.xSpeed = 0;
        this.setInputControl();
    },

    update: function update(dt) {
        if (this.accLeft) {
            this.xSpeed -= this.accel * dt;
        }
        if (this.accRight) {
            this.xSpeed += this.accel * dt;
        }
        if (Math.abs(this.xSpeed) > this.maxMoveSpeed) {
            this.xSpeed = this.maxMoveSpeed * Math.abs(this.xSpeed) / this.xSpeed;
        }
        if (this.node.y > 21) {
            this.wthJump = false;
        }
        if (this.wthJump) {
            this.setJump();
        }
        this.node.x += this.xSpeed * dt;
    }
});