cc.Class({
    'extends': cc.Component,

    properties: {
        starPrefab: {
            'default': null,
            type: cc.Prefab
        },
        ground: {
            'default': null,
            type: cc.Node
        },
        player: {
            'default': null,
            type: cc.Node
        },

        starDuration: 0
    },
    onLoad: function onLoad() {
        this.groundY = this.ground.y + this.ground.height / 2;
        this.spawnNewStar();
    },
    spawnNewStar: function spawnNewStar() {
        var newStar = cc.instantiate(this.starPrefab);
        this.node.addChild(newStar);
        newStar.setPosition(this.getStarPosition());
        //我理解为在动态生成的Star里的Star脚本里生成叫做‘game’的属性
        newStar.getComponent('Star').game = this;
    },
    getStarPosition: function getStarPosition() {
        var randY = this.groundY + cc.random0To1() * this.player.getComponent('jump').jumpHeight + 50;
        var randX = 0;
        randX = cc.randomMinus1To1() * this.node.width / 2;
        return cc.p(randX, randY);
    }

});
//test

// called every frame, uncomment this function to activate update callback
// update: function (dt) {

// },