var ANIMATIONS_NUMBER = {
    toTheLeft: {
        //被攻击
        beAttacked:{
            start: 37,
            end: 42
        },
        //死亡
        die:{
            start: 121,
            end: 132
        },
        //作揖
        hello: {
            start: 211,
            end: 221
        },
        //刀法1
        knife1: {
            start: 341,
            end: 349
        },
        //刀法2
        knife2: {
            start: 350,
            end: 358
        },
        //斧头
        axe: {
            start: 425,
            end: 432
        },
        //弓箭
        bow: {
            start: 495,
            end: 503
        },
        //剑法1
        sword1: {
            start: 627,
            end: 635
        },
        //剑法2
        sword2: {
            start: 636,
            end: 645
        },
        //枪法
        spear: {
            start: 713,
            end: 720
        },
        //拳法1
        fist1: {
            start: 819,
            end: 825
        },
        //拳法2
        fist2: {
            start: 826,
            end: 833
        },
        //投掷
        throw: {
            start: 909,
            end: 918
        },
        //小步走路
        walk_small: {
            start: 995,
            end: 1005
        },
        //大步走路
        walk_big: {
            start: 1119,
            end: 1135
        },
        //带武器走路
        walk_weapon: {
            start: 1255,
            end: 1271
        },
        //站立
        stand: {
            start: 1491,
            end: 1493
        },
        //攻击姿态
        standAttack: {
            start: 1515,
            end: 1517
        },
    },
    toTheRight: {
        beAttacked:{
            start: 13,
            end: 18
        },
        die:{
            start: 73,
            end: 84
        },
        hello: {
            start: 167,
            end: 177
        },
        knife1: {
            start: 269,
            end: 277
        },
        knife2: {
            start: 278,
            end: 286
        },
        axe: {
            start: 393,
            end: 400
        },
        bow: {
            start: 459,
            end: 467
        },
        sword1: {
            start: 551,
            end: 559
        },
        sword2: {
            start: 560,
            end: 569
        },
        spear: {
            start: 681,
            end: 688
        },
        fist1: {
            start: 759,
            end: 765
        },
        fist2: {
            start: 766,
            end: 773
        },
        throw: {
            start: 869,
            end: 878
        },
        walk_small: {
            start: 951,
            end: 961
        },
        walk_big: {
            start: 1051,
            end: 1067
        },
        walk_weapon: {
            start: 1187,
            end: 1203
        },
        stand: {
            start: 1485,
            end: 1487
        },
        standAttack: {
            start: 1479,
            end: 1481
        }
    },
    toTheFront:{
        stand: {
            start: 1485,
            end: 1487
        },
        standAttack: {
            start: 1509,
            end: 1511
        },
        standUp: {
            start: 1429,
            end: 1439
        },
        sitDown: {
            start: 1333,
            end: 1343
        }
    }
};
var ANIMATION_SAMPLE = 17;

cc.Class({
    extends: cc.Component,

    properties: {
        wear: cc.Node,
        //加载完成的图集资源数量
        ready: 0,
        _wear1: "",
        _wear2: "",
        //需要加载的图集资源数量
        _count: 1,
        //是否所有图集加载完成
        _allLoaded: false,
        //托管
        _trusteeship: null
    },
    // use this for initialization
    onLoad: function () {
        this.init();
        this.playAnimation("toTheLeft-walk_big"); 
    },

    //初始化方法，加载人体本身的图集并添加clip
    init: function(){
        cc.log("--------------init---------------------")
        var self = this;
        //人物身体的动画组件
        var animComponent = self.node.getComponent(cc.Animation);
        var resName = "mjs001";
        cc.loader.loadRes("manRole", cc.SpriteAtlas, function(err, atlas){
            //面向前的动画
            for (var key in ANIMATIONS_NUMBER.toTheFront) {
                if (ANIMATIONS_NUMBER.toTheFront.hasOwnProperty(key)) {
                    var element1 = ANIMATIONS_NUMBER.toTheFront[key];
                    var frames1 = [];
                    for(var i = element1.start; i <= element1.end; i++){
                        frames1.push(atlas.getSpriteFrame(resName + "-" + i));
                    }
                    var clip1 = cc.AnimationClip.createWithSpriteFrames(frames1, ANIMATION_SAMPLE);
                    clip1.name = "toTheFront-" + key;
                    clip1.warpMode = cc.WrapMode.Loop;
                    animComponent.addClip(clip1);
                }
            }
            //面向左的动画
            for (var key in ANIMATIONS_NUMBER.toTheLeft) {
                if (ANIMATIONS_NUMBER.toTheLeft.hasOwnProperty(key)) {
                    var element2 = ANIMATIONS_NUMBER.toTheLeft[key];
                    var frames2 = [];
                    for(var j = element2.start; j <= element2.end; j++){
                        frames2.push(atlas.getSpriteFrame(resName + "-" + j));
                    }
                    var clip2 = cc.AnimationClip.createWithSpriteFrames(frames2, ANIMATION_SAMPLE);
                    clip2.name = "toTheLeft-" + key;
                    clip2.warpMode = cc.WrapMode.Loop;
                    animComponent.addClip(clip2);
                }
            }
            //面向右的动画
            for (var key in ANIMATIONS_NUMBER.toTheRight) {
                if (ANIMATIONS_NUMBER.toTheRight.hasOwnProperty(key)) {
                    var element3 = ANIMATIONS_NUMBER.toTheRight[key];
                    var frames3 = [];
                    for(var k = element3.start; k <= element3.end; k++){
                        frames3.push(atlas.getSpriteFrame(resName + "-" + k));
                    }
                    var clip3 = cc.AnimationClip.createWithSpriteFrames(frames3, ANIMATION_SAMPLE);
                    clip3.name = "toTheRight-" + key;
                    clip3.warpMode = cc.WrapMode.Loop;
                    animComponent.addClip(clip3);
                }
            }
            //加载好的数量+1；
            self.ready++;
            //检查所有图集是否加载完成
            self.check();
        })
        //初始化衣服
        this.wear1("m1yf001");
        //this.wear2("m12yf001");
    },
    //更换衣服1
    addWear: function(){
        this.wear1("m1yf001");
        this.playAnimation("toTheRight-walk_weapon");
    },
    //更换衣服2
    addWear2: function(){
        this.wear2("m12yf001");
        this.playAnimation("toTheRight-walk_weapon");
    },
    //播放动画
    playA: function(){
        this.playAnimation("toTheRight-knife1")
    },
    //衣服1
    wear1: function(){
        cc.log("--------------wear1---------------------")
        //马上要加载图集，所以allLoaded为false
        this._allLoaded = false;
        //如果之前已经有一张图集了
        if(this._wear2){
            //所有动画clip
            var clips = this.wear.getComponent(cc.Animation)._clips
            //释放精灵帧
            cc.loader.releaseAsset(this.wear.getComponent(cc.Sprite).spriteFrame);
            //释放所有clip
            for (var key in clips) {
                if (clips.hasOwnProperty(key)) {
                    var element = clips[key];
                    cc.loader.releaseAsset(element);
                    cc.log("key = " + key);
                }
            }
            //删除clip数组
            clips.splice(0, clips.length);
            //释放图集
            cc.loader.releaseRes("m12yf001");
            this._wear2 = null;
            cc.log("-----------------------releaseRes--------------------------")
        }
        //图集count+1
        this._count++;
        this.stopAnimation();
        var self = this;
        var animComponent = self.wear.getComponent(cc.Animation);
        //spriteFrame的编号
        var curNum = 167;
        cc.loader.loadRes("m1yf001", cc.SpriteAtlas, function(err, atlas){
            self._wear1 = "m1yf001";
            self.wear.getComponent(cc.Sprite).spriteFrame = atlas.getSpriteFrame(self._wear1  + "-" + curNum);
            cc.log("wear1 loaded " + self._wear1  + "-" + curNum);
            for (var key in ANIMATIONS_NUMBER.toTheFront) {
                if (ANIMATIONS_NUMBER.toTheFront.hasOwnProperty(key)) {
                    var element1 = ANIMATIONS_NUMBER.toTheFront[key];
                    var frames1 = [];
                    for(var i = element1.start; i <= element1.end; i++){
                        frames1.push(atlas.getSpriteFrame(self._wear1  + "-" + i));
                    }
                    var clip1 = cc.AnimationClip.createWithSpriteFrames(frames1, ANIMATION_SAMPLE);
                    clip1.name = "toTheFront-" + key;
                    clip1.warpMode = cc.WrapMode.Loop;
                    animComponent.addClip(clip1);
                }
            }

            for (var key in ANIMATIONS_NUMBER.toTheLeft) {
                if (ANIMATIONS_NUMBER.toTheLeft.hasOwnProperty(key)) {
                    var element2 = ANIMATIONS_NUMBER.toTheLeft[key];
                    var frames2 = [];
                    for(var j = element2.start; j <= element2.end; j++){
                        frames2.push(atlas.getSpriteFrame(self._wear1  + "-" + j));
                    }
                    var clip2 = cc.AnimationClip.createWithSpriteFrames(frames2, ANIMATION_SAMPLE);
                    clip2.name = "toTheLeft-" + key;
                    clip2.warpMode = cc.WrapMode.Loop;
                    animComponent.addClip(clip2);
                }
            }

            for (var key in ANIMATIONS_NUMBER.toTheRight) {
                if (ANIMATIONS_NUMBER.toTheRight.hasOwnProperty(key)) {
                    var element3 = ANIMATIONS_NUMBER.toTheRight[key];
                    var frames3 = [];
                    for(var k = element3.start; k <= element3.end; k++){
                        frames3.push(atlas.getSpriteFrame(self._wear1  + "-" + k));
                    }
                    var clip3 = cc.AnimationClip.createWithSpriteFrames(frames3, ANIMATION_SAMPLE);
                    clip3.name = "toTheRight-" + key;
                    clip3.warpMode = cc.WrapMode.Loop;
                    animComponent.addClip(clip3);
                }
            }
            self.ready++;
            self.check();
        })
        
    },

    wear2: function(){
        cc.log("--------------wear2---------------------")
        this._allLoaded = false;
        if(this._wear1){
            var clips = this.wear.getComponent(cc.Animation)._clips
            cc.loader.releaseAsset(this.wear.getComponent(cc.Sprite).spriteFrame);
            for (var key in clips) {
                if (clips.hasOwnProperty(key)) {
                    var element = clips[key];
                    cc.loader.releaseAsset(element);
                    cc.log("key = " + key);
                }
            }
            clips.splice(0, clips.length);
            cc.loader.releaseRes("m1yf001");
            this._wear1 = null;
            cc.log("-----------------------releaseRes--------------------------")
        }
        this._count++;
        var self = this;
        this.stopAnimation();
        var curNum = 167;
        var animComponent = self.wear.getComponent(cc.Animation);
        cc.loader.loadRes("m12yf001", cc.SpriteAtlas, function(err, atlas){
            self._wear2 = "m12yf001";
            cc.log("wear2 loaded " + self._wear1  + "-" + curNum);
            for (var key in ANIMATIONS_NUMBER.toTheFront) {
                if (ANIMATIONS_NUMBER.toTheFront.hasOwnProperty(key)) {
                    var element1 = ANIMATIONS_NUMBER.toTheFront[key];
                    var frames1 = [];
                    for(var i = element1.start; i <= element1.end; i++){
                        frames1.push(atlas.getSpriteFrame(self._wear2  + "-" + i));
                    }
                    var clip1 = cc.AnimationClip.createWithSpriteFrames(frames1, ANIMATION_SAMPLE);
                    clip1.name = "toTheFront-" + key;
                    clip1.warpMode = cc.WrapMode.Loop;
                    animComponent.addClip(clip1);
                }
            }

            for (var key in ANIMATIONS_NUMBER.toTheLeft) {
                if (ANIMATIONS_NUMBER.toTheLeft.hasOwnProperty(key)) {
                    var element2 = ANIMATIONS_NUMBER.toTheLeft[key];
                    var frames2 = [];
                    for(var j = element2.start; j <= element2.end; j++){
                        frames2.push(atlas.getSpriteFrame(self._wear2  + "-" + j));
                    }
                    var clip2 = cc.AnimationClip.createWithSpriteFrames(frames2, ANIMATION_SAMPLE);
                    clip2.name = "toTheLeft-" + key;
                    clip2.warpMode = cc.WrapMode.Loop;
                    animComponent.addClip(clip2);
                }
            }

            for (var key in ANIMATIONS_NUMBER.toTheRight) {
                if (ANIMATIONS_NUMBER.toTheRight.hasOwnProperty(key)) {
                    var element3 = ANIMATIONS_NUMBER.toTheRight[key];
                    var frames3 = [];
                    for(var k = element3.start; k <= element3.end; k++){
                        frames3.push(atlas.getSpriteFrame(self._wear2  + "-" + k));
                    }
                    var clip3 = cc.AnimationClip.createWithSpriteFrames(frames3, ANIMATION_SAMPLE);
                    clip3.name = "toTheRight-" + key;
                    clip3.warpMode = cc.WrapMode.Loop;
                    animComponent.addClip(clip3);
                }
            }
            self.ready++;
            self.check();
        })
    },
    //播放动画
    playAnimation: function(animName, repeatCount){
        cc.log("animName = " + animName + "------------repeatCount = " + repeatCount);
        //所有图集都加载完成了才会播放动画，如果没有加载完，先把播放操作进行托管然后直接退出
        if(!this._allLoaded){
            this._trusteeship = this.playAnimation.bind(this, animName, repeatCount);
            cc.log("trusteeshiping....");
            return ;
        }
        var state1 = this.node.getComponent(cc.Animation).play(animName);
        if(typeof repeatCount == "undefined"){
            state1.repeatCount = Infinity;
        }else{
            state1.repeatCount = repeatCount;
        }  
        if(this.wear.active){
            var state2 = this.wear.getComponent(cc.Animation).play(animName);
            if(typeof repeatCount == "undefined"){
                state2.repeatCount = Infinity;
            }else{
                state2.repeatCount = repeatCount;
            }
        }
      this._trusteeship = null;
    },

    check: function(){
        cc.log("--------------check---------------------")
        //如果加载完成的图集数量和需要加载的图集数量相等，则更改allLoaded的状态，并且如果有托管操作，现在执行托管的函数
        if(this.ready == this._count){
            this._allLoaded = true;
            cc.log("all loaded");
            if(this._trusteeship){
                this._trusteeship();
            }
        }else{
            this._allLoaded = false;
        }
        cc.log("count = " + this._count + "-----ready = " + this.ready);
    },

    stopAnimation: function(event){
        this.node.getComponent(cc.Animation).stop();
        this.wear.getComponent(cc.Animation).stop();
    }
    // called every frame
    // update: function (dt) {
    //     // var lb = this.bg.getChildByName("label1");
    //     // cc.log("width = " + lb.width + "-----------" + "height = " + lb.height );
    // },
});
