cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function () {
        this.label.string = this.text;
          //画布，响应事件
        this.toolStatus=1;
        var paletteNode=cc.find('Canvas/palette');
        this.paletteNode=paletteNode;
        this.ctx=paletteNode.getComponent(cc.Graphics);
        paletteNode.on(cc.Node.EventType.TOUCH_START, function (event) {
            console.log('paletteNode touch start');
            //var l=event.touch.getLocation();
            //console.log('x:',l.x,",y:",l.y);
            this.onTouchBegan(event);
        }, this);
        paletteNode.on(cc.Node.EventType.TOUCH_MOVE, function (event) {
            console.log('paletteNode move');
            this.onTouchMoved(event);
        }, this);
        paletteNode.on(cc.Node.EventType.TOUCH_END, function (event) {
            console.log('paletteNode touch end');
            this.onTouchEnded(event);
        }, this);
    },
     /*画布触摸开始*/
    onTouchBegan: function (event) {
        var touch=event.touch;
        if (this.toolStatus == 1) {
            var touchLoc = touch.getLocation();
            touchLoc=this.paletteNode.convertToNodeSpaceAR(touchLoc);
            console.log('onTouchBegan,x,y',touchLoc.x,touchLoc.y);
            this.originPoint = touchLoc;
        }
        return true;
    },
    /*画布触摸移动*/
    onTouchMoved: function (event) {
        var touch=event.touch;
        var touchLoc = touch.getLocation();
        touchLoc=this.paletteNode.convertToNodeSpaceAR(touchLoc);
        console.log('onTouchMoved,x,y',touchLoc.x,touchLoc.y);
        if (this.toolStatus == 1 ) { // ||this.toolStatus == 2  
            this.ctx.strokeColor=cc.Color.RED;
            this.ctx.lineWidth=10;
            this.ctx.moveTo(this.originPoint.x,this.originPoint.y);
            this.ctx.lineTo(touchLoc.x,touchLoc.y);
            this.ctx.fill();
            this.ctx.stroke();
            this.originPoint = touchLoc;
        } 
    },
    /*画布触摸结束*/
    onTouchEnded: function (event) {
        //var touch=event.touch;

    },
    // called every frame
    update: function (dt) {

    },
});
