"use strict";

cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    // use this for initialization
    onLoad: function onLoad() {
        cc.log("onLoad");
        this.DrawLocalImage(this.node.getChildByName("Pai1"), "Playing/Pai/bottomChu/W_1");
        this.DrawLocalImage(this.node.getChildByName("Pai2"), "Playing/Pai/bottomChu/W_2");
    },

    // called every frame
    update: function update(dt) {},

    DrawLocalImage: function DrawLocalImage(ThisNode, Url) {
        var sf = cc.loader.getRes(Url, cc.SpriteFrame);
        if (sf) {
            ThisNode.getComponent(cc.Sprite).spriteFrame = sf;

            return;
        }

        cc.loader.loadRes(Url, cc.SpriteFrame, function (err, newSpriteFrame) {
            cc.log("DrawLocalImage", Url + "   " + err);

            ThisNode.getComponent(cc.Sprite).spriteFrame = newSpriteFrame;
        });
    }
});