const STANDUP = 1;
const SITDOWN = 2;
cc.Class({
    extends: cc.Component,

    properties: {
        _handCard: [],
        cardPrefab: cc.Prefab,
        _touchBegan: null,
        _touchMoved: null,
    },

    _getCardForTouch: function (touch, cardArr) {
        for (var k in cardArr) {
            var box = cardArr[k].getBoundingBox();
            if (cc.rectContainsPoint(box, touch)) {
                cardArr[k].isChiose = true;
                cardArr[k].opacity = 155;
                return cardArr[k];
            }
        }
    },

    _checkSelectCardReserve(touchBegan, touchMoved) {
        var p1 = touchBegan.x < touchMoved.x ? touchBegan : touchMoved;
        var width = Math.abs(touchBegan.x - touchMoved.x);
        var height = Math.abs(touchBegan.y - touchMoved.y) > 5 ? Math.abs(touchBegan.y - touchMoved.y) : 5;
        var rect = cc.rect(p1.x, p1.y, width, height);
        for (let i = 0; i < this._handCard.length; i++) {
            if (!cc.rectIntersectsRect(this._handCard[i].getBoundingBox(), rect)) {
                this._handCard[i].isChiose = false;
                this._handCard[i].opacity = 255;
            }
        }
        if (p1 === touchMoved) {
            for (let i = this._handCard.length - 1; i >= 0; i--) {
                if (p1.x - this._handCard[i].x > 84) {  //
                    this._handCard[i].opacity = 255;
                    this._handCard[i].isChiose = false;
                }
            }
        }

    },

    touchBegan: function (event) {
        // var self = this;
        var touches = event.getTouches();
        var touchLoc = touches[0].getLocation();
        this._touchBegan = this.node.convertToNodeSpace(touchLoc);
        this._getCardForTouch(touchLoc, this._handCard);
    },

    touchMoved: function (event) {
        var self = this;
        var touches = event.getTouches();
        var touchLoc = touches[0].getLocation();
        this._touchMoved = this.node.convertToNodeSpace(touchLoc);
        self._getCardForTouch(touchLoc, self._handCard);
        this._checkSelectCardReserve(this._touchBegan, this._touchMoved);
    },

    touchCancel: function () {

    },

    touchEnd: function (event) {
        var touches = event.getTouches();
        var touchLoc = touches[0].getLocation();
        for (var k in this._handCard) {
            this._handCard[k].opacity = 255;
            if (this._handCard[k].isChiose === true) {
                this._handCard[k].isChiose = false;
                if (this._handCard[k].status === SITDOWN) {
                    this._handCard[k].status = STANDUP;
                    this._handCard[k].y += 20;
                } else {
                    this._handCard[k].status = SITDOWN;
                    this._handCard[k].y -= 20;
                }
            }
        }
    },

    onTouchEvent: function () {
        this.node.on(cc.Node.EventType.TOUCH_START, this.touchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.touchCancel, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.touchEnd, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.touchMoved, this);
    },

    offTouchEvent: function () {
        this.node.off(cc.Node.EventType.TOUCH_START, this.touchBegan, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this.touchCancel, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this.touchEnd, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this.touchMoved, this);
    },

    // use this for initialization
    onLoad: function () {
        this.onTouchEvent();
        for (var i = 0; i < 10; i++) {
            var cardPrefab = cc.instantiate(this.cardPrefab);
            cardPrefab.status = SITDOWN;
            cardPrefab.isChiose = false;
            cardPrefab.index = i;
            this._handCard.push(cardPrefab);
        }
        var drawX = 1280 / 2 + ((this._handCard.length - 1) / 2) * 60;
        for (let i = this._handCard.length - 1; i >= 0; i--) {
            this.node.addChild(this._handCard[i]);
            this._handCard[i].position = cc.p(drawX - i * 60, 100);
        }
    }
    // called every frame, uncomment this function to activate update callback
    // update: function (dt) {

    // },
});
