/******************************************************************************
 * 作者:姜尔西
 * 此组件用于创建自定义的帧动画。实现多个不同图片的帧动画共用。
 * 
 * 此组件的设计思路是这样的：
 * 1、通过一个format字符串（json）来配置此组件的帧信息（格式见properties中）
 * 2、通过spriteFrame属性来指定此动画所对应的图片。
 * 3、通过Clip类来管理每一个动作。此类中包括了每一个动作所拥有的cc.SpriteFrame
 *    对象。
 * 4、通过play(name)函数来进行动作的播放。
 * 5、在update中，根据环境对绑定的目标进行SpriteFrame的替换，以实现帧动画播放。
 * 
 * 使用方式：
 * 使用时将此项目附加到node上。拖动图片到spriteFrame项中，在format中配置参数。
 * 
 * 修改说明：
 * 目前仅支持从左到右的动画。每加入一个frame，pointX的值步进。可以根据自己的思
 * 路修改代码，实现不同的载入方式。
******************************************************************************/
var CharaAlpha = cc.Class({
    extends: cc.Animation,
    
    statics:{
        Clip:cc.Class({
            ctor:function(){
                this.frames = [];
            },
            
            setInfo:function(info, clip){
                var t = this;
                t.name = clip[0];
                t.count = clip[1];
                t.size = clip[2];
                if (t.size == null){
                    t.size = info.size;
                }
            },
            
            addFrame:function(frame){
                this.frames.push(frame);
                if (cc.sys.isNative){
                    frame.retain();
                }
            },
            
            clear:function(){
                if (cc.sys.isNative){
                    for (var i = 0, len = this.frames.length; i < len; i++){
                        this.frames[i].release();
                    }
                }
                
                this.frames = [];
            }
        }),
    },

    properties: {
        spriteFrame:{
            default:null,
            type:cc.SpriteFrame
        },
        // Format Setting Description:
        // @time The time of each frame
        // @size The default size of clip, each clip could have own size.
        // @clips Define each clips
        // @defaultAction The action should play at "onLoad"
        // Clip format, define as an array:
        // 1. Action name.
        // 2. Frame count.
        // 3. Sprite size, if unset, use default size.
        // {time:0.1,size:[250,200],clips:[["attack",3],["move",4,[300,200]]]}
        format:{
            default:''
        },
    },
    
    
    setFormat: function(str){
        this.format = str;
        this.info = null;
        this.analyzeFormat();
    },
    
    analyzeFormat: function(){
        var t = this;
        
        if (t.info != null) return true;
        
        if (t.format == null || t.format.length == 0){
            cc.log("Unset CharaAlpha Format");
            return false;
        }
        t.info = eval("(" + t.format + ")");
        if (t.info.time == null){
            t.info.time = 0.1;
        } 
        
        return true;
    },
    
    setInfo: function(info){
        this.info = info;
    },
    
    getTexture:function(){
        return this.spriteFrame.getTexture();
    },

    // use this for initialization
    onLoad: function () {
        var t = this;
        
        t.createFrames();
        t.resetClip();
        
        t.playDefaultAction();
    },
    
    createFrames:function(){
        var t = this;
        
        t.clear();
        
        if (!t.analyzeFormat()) return ;
        
        for (var i = 0, len = t.info.clips.length; i < len; i++){
            var clip = new CharaAlpha.Clip();
            clip.setInfo(t.info, t.info.clips[i]);
            t.clipList.push(clip);
            t.createClip(clip);
        }
    },
    
    clear:function(){
        var t = this;
        if (t.clipList != null){
            for (var i = 0, len = t.clipList.length; i < len; i++){
                t.clipList.clear();
            }
        }
        t.clipList = [];
        t.pointX = 0;
    },
    

    
    createClip:function(clip){
        var t = this;
        var width = clip.size[0];
        var height = clip.size[1];
        for (var i = 0; i < clip.count; i++){
            var f = new cc.SpriteFrame(t.getTexture(), new cc.Rect(t.pointX, 0, width, height));
            clip.addFrame(f);
            t.pointX += width;
        }
    },
    
    
    playDefaultAction:function(){
        if (this.info != null && this.info.defaultAction != null){
            this.play(this.info.defaultAction);
        }
    },
    
    resetClip:function(){
        var t = this;
        t.currentClip = null;
        t.currentIdx = 0;
        t.stack = 0;
    },
    
    setCurrentClip:function(clip){
        var t = this;
        t.resetClip();
        t.currentClip = clip;
    },
    
    checkStack:function(dt){
        var t = this;
        t.stack += dt;
        if (t.stack > t.info.time){
            t.stack -= t.info.time;
            return true;
        }else{
            return false;
        }
    },
    
    getCurrentFrame:function(){
        var t = this;
        var f = t.currentClip.frames[t.currentIdx];
        t.currentIdx++;
        if (t.currentIdx >= t.currentClip.count){
            t.currentIdx = 0;
        }
        return f;
    },
    
    play:function(name){
        var t = this;
        if (t.clipList == null) return ;
        for (var i = 0, len = t.clipList.length; i < len; i++){
            if (t.clipList[i].name == name){
                t.setCurrentClip(t.clipList[i]);
                return ;
            }
        }
    },
    
    setSpriteFrame:function(){
        var t = this;
        var sp = t.node.getComponent(cc.Sprite)
        sp.spriteFrame = t.getCurrentFrame();
        t.node.width = t.currentClip.size[0];
        t.node.height = t.currentClip.size[1];
    },

    // called every frame, uncomment this function to activate update callback
    update: function (dt) {
        var t = this;
        if (t.currentClip == null) return ;
        if (!t.checkStack(dt)) return ;
        t.setSpriteFrame();
    },
});
