cc.Class({
    'extends': cc.Component,

    properties: {
        cocos: {
            'default': null,
            type: cc.Node
        },
        label: {
            'default': null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!'
    },

    onLoad: function onLoad() {
        this.label.string = this.text;
        this.cocos.runAction(this.setJumpAction());
    },

    setJumpAction: function setJumpAction() {
        var jumpUp = cc.moveBy(0.5, cc.p(0, 200)).easing(cc.easeCubicActionOut());
        var jumpDown = cc.moveBy(0.5, cc.p(0, -200)).easing(cc.easeCubicActionIn());
        return cc.repeatForever(cc.sequence(jumpUp, jumpDown));
    },

    onBtnClick: function onBtnClick() {
        this.label.string = this.cocos.getPositionY().toString();
    }
});