cc.Class({
    "extends": cc.Component,

    properties: {

        // defaults, set visually when attaching this script to the Canvas
        url: 'http://121.42.14.141/music/map1.jpg'
    },

    // use this for initialization
    onLoad: function onLoad() {
        var _this = this;

        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        cc.loader.load(this.url, function (err, texture) {

            if (err == null) {
                _this.node.getComponent(cc.Sprite).spriteFrame.setTexture(texture);
            }
        });
    },

    onDestory: function onDestory() {
        cc.systemEvent.off(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
    },

    onKeyDown: function onKeyDown(event) {
        switch (event.keyCode) {
            case cc.KEY.enter:
                cc.director.loadScene("test");
                break;
        }
    },

    // called every frame
    update: function update(dt) {}
});