"use strict";
cc._RFpush(module, '092a3wYF7pBULdP9SLwGUBQ', 'Shooter');
// cases\collider\Shooter\Shooter.js

var _pool = null;
var _last = null;

cc.Class({
    "extends": cc.Component,

    properties: {
        //
        bullet: {
            "default": null,
            type: cc.Node
        }
    },

    // use this for initialization
    onLoad: function onLoad() {
        var _this = this;

        cc.director.getCollisionManager().enabled = true;
        cc.director.getCollisionManager().enabledDebugDraw = true;

        _pool = new cc.NodePool("bullet");

        var scene = cc.director.getScene();

        cc.eventManager.addListener({
            event: cc.EventListener.TOUCH_ONE_BY_ONE,
            onTouchBegan: function onTouchBegan(touch, event) {
                var touchLoc = touch.getLocation();

                var bullet = null;
                if (_pool && _pool.size() > 0) {
                    bullet = _pool.get();
                } else {
                    bullet = cc.instantiate(_this.bullet);
                }

                var com = bullet.getComponent("Bullet");
                if (com == _last) {
                    cc.log("--同一个对象？");
                }
                _last = com;

                com.setFunc(function () {
                    _pool.put(bullet);
                    cc.log("recycle now--");
                });

                bullet.position = touchLoc;
                bullet.active = true;
                bullet.zIndex = -1;
                scene.addChild(bullet);
                return true;
            }
        }, this.node);
    },

    onDisable: function onDisable() {
        cc.director.getCollisionManager().enabled = false;
        cc.director.getCollisionManager().enabledDebugDraw = false;
    }

    // called every frame, uncomment this function to activate update callback
    // update: function (dt) {

    // },
});

cc._RFpop();