cc.Class({
    "extends": cc.Component,

    properties: {
        pickRadius: 0
    },
    //获取主角和星星的距离
    getPlayerDistance: function getPlayerDistance() {
        //获取player（主角）节点的位置
        var playerPos = this.game.player.getPosition();
        //根据两点位置计算两点之间的距离
        var dist = cc.pDistance(this.node.position, playerPos);

        return dist;
    },

    //如果星星和主角的距离小于pickRadius的值（主角可以收集星星），就执行此函数
    onPicked: function onPicked() {
        //当星星被收集时，调用Game脚本中的接口（Game实例中的方法），生成一个新的星星
        this.game.spawnNewStar();
        //调用Game脚本的得分方法
        this.game.gainScore();
        //然后销毁当前星星节点
        this.node.destroy();
    },

    update: function update(dt) {
        if (this.getPlayerDistance() < this.pickRadius) {
            this.onPicked();
            return;
        }
    },
    // use this for initialization
    onLoad: function onLoad() {}

});
// called every frame, uncomment this function to activate update callback
// update: function (dt) {

// },