cc.Class({
    'extends': cc.Component,

    properties: {
        //这个属性引用了星星预制资源
        starPrefab: {
            'default': null,
            //预制类型
            type: cc.Prefab
        },
        //星星产生后消失时间的随机范围
        maxStarDuration: 0,
        minStarDuration: 0,

        //地面节点，用于确定星星生成的高度
        ground: {
            'default': null,
            type: cc.Node
        },

        //Player节点，用于获取主角弹跳的高度，和控制主角行动开关
        player: {
            'default': null,
            type: cc.Node
        },

        scoreDisplay: {
            'default': null,
            type: cc.Label
        }
    },

    // use this for initialization
    onLoad: function onLoad() {
        //获取地平面的Y轴坐标
        this.groundY = this.ground.y + this.ground.height / 2;
        //生成一个新的星星
        this.spawnNewStar();
        //初始化计分
        this.score = 0;
    },
    //生成一个新的星星
    spawnNewStar: function spawnNewStar() {
        //用给定的星星模版在场景中生成一个新的星星
        var newStar = cc.instantiate(this.starPrefab);
        //把新生成的星星添加到Cavans节点下面（因为Game.js是添加到Cavans节点下，所以这里的this就是Cavans）
        this.node.addChild(newStar);
        //为星星设置一个随机位置
        newStar.setPosition(this.getNewStarPosition());
        //将Game组件的实例传入星星组件
        newStar.getComponent('Star').game = this;
    },
    //为星星生成一个随机位置
    getNewStarPosition: function getNewStarPosition() {
        var randX = 0;
        //根据地平面位置和主角跳跃高度，随机得到一个星星的Y坐标
        var randY = this.groundY + cc.random0To1() * this.player.getComponent('Player').jumpHeight + 50;
        //根据屏幕宽度，随机得到一个星星的X坐标(cc.randomMinus1To1()是获取-1到1的随机数，
        //以屏幕中心为原点，如果得到负数，就是在左边，如果得到整数，就是在右边)
        var maxX = this.node.width / 2;
        //获取相对于屏幕中心的最大值和最小值
        randX = cc.randomMinus1To1() * maxX;

        return cc.p(randX, randY);
    },

    // called every frame, uncomment this function to activate update callback
    // update: function (dt) {

    // },
    //得分+1
    gainScore: function gainScore() {
        this.score += 1;
        this.scoreDisplay.string = 'Score: ' + this.score.toString();
    },

    claer: function claer() {
        this.score = 0;
        this.scoreDisplay.string = 'Score: ' + this.score.toString();
    },

    changed: function changed(EditBox, text) {
        var eb = cc.find("Canvas/EditBox");
        this.scoreDisplay.string = 'Score: ' + eb.text;
    }
});