
var Item = cc.Class({
    name: 'Item',
    properties: {
        id: 0,
        itemName: '',
        itemPrice: 0,
        iconSF: cc.SpriteFrame
    }
});

cc.Class({
    'extends': cc.Component,
    properties: {
        items: {
            'default': [],
            type: [Item]
        },
        itemPrefab: cc.Prefab
    },

    // use this for initialization
    onLoad: function onLoad() {
        for (var i = 0; i < this.items.length; i++) {
            var item = cc.instantiate(this.itemPrefab);
            var data = this.items[i];
            this.node.addChild(item);
            item.getComponent('ItemTemplate').init({
                id: data.id,
                itemName: data.itemName,
                itemPrice: data.itemPrice,
                iconSF: data.iconSF
            });
        }
        cc.log('length = ' + this.items.length);
        for (var value in this.items) {
            var element = this.items[value];
            cc.log(value + "=====" + JSON.stringify(element));
        }
    }

});
// called every frame, uncomment this function to activate update callback
// update: function (dt) {

// },