let _default_vert_no_mvp = require("../Shaders/ccShader_Default_Vert_noMVP.js");
let _trapezoidal_frag_left = require("../shaders/ccShader_Trapezoidal_Frag_left.js");
let _trapezoidal_frag_right = require("../shaders/ccShader_Trapezoidal_Frag_right.js");

let Shader_Trapezoidal = cc.Class({
    extends: cc.Component,

    properties: {
        shader_index: 0,
        isAllChildrenUser:false,
        is_left: false,
        scale: 0,
    },

    onLoad: function () {
        this._use();
    },

    _use: function()
    {
        let _trapezoidal_frag = this.is_left ? _trapezoidal_frag_left: _trapezoidal_frag_right;
        if (cc._renderType === cc.game.RENDER_TYPE_WEBGL) {
            this._program = new cc.GLProgram();
            this._program.initWithVertexShaderByteArray(_default_vert_no_mvp, _trapezoidal_frag);
            this._program.addAttribute(cc.macro.ATTRIBUTE_NAME_POSITION, cc.macro.VERTEX_ATTRIB_POSITION);
            this._program.addAttribute(cc.macro.ATTRIBUTE_NAME_COLOR, cc.macro.VERTEX_ATTRIB_COLOR);
            this._program.addAttribute(cc.macro.ATTRIBUTE_NAME_TEX_COORD, cc.macro.VERTEX_ATTRIB_TEX_COORDS);
            this._program.link();
            this._program.updateUniforms();

            this._uni_scale = this._program.getUniformLocationForName("scale");
            this._program.setUniformLocationWith1f(this._uni_scale, this.scale);

            this.setProgram( this.node._sgNode, this._program );
        }
    },
    setProgram:function (node, program) {

        node.setShaderProgram(program);

        let children = node.children;
        if (!children) {
            return;
        }
    
        for (let i = 0; i < children.length; i++)
        {
            this.setProgram(children[i], program);
        }
    },
});

module.exports = Shader_Trapezoidal;



