//
//  SimpleLoader.cpp
//  cocos2d_libs
//
//  Created by liuyi on 16/4/5.
//
//

#include "SimpleLoader.hpp"
#include <thread>
#include "cocos2d.h"
#include "base/CCDirector.h"
#include "base/CCScheduler.h"
#include "base/CCUserDefault.h"
#include "network/CCDownloader.h"
#include "platform/CCFileUtils.h"
#include "ScriptingCore.h"

#include <sstream>
#include "base/CCDirector.h"
#include "base/CCEventListenerCustom.h"
#include "base/CCEventDispatcher.h"
#include "base/CCEventType.h"
#include "base/CCEventCustom.h"

#include <stdio.h>
#include <regex>

#ifdef MINIZIP_FROM_SYSTEM
#include <minizip/unzip.h>
#else // from our embedded sources
#include "external/unzip/unzip.h"
#endif

//NS_CC_EXT_BEGIN;

using namespace std;
using namespace cocos2d;
using namespace cocos2d::network;

#define BUFFER_SIZE    1024*100
#define MAX_FILENAME   512

SimpleLoader::SimpleLoader()
:_downloader(new Downloader())
, _connectionTimeout(0)
, _delegate(nullptr)
, _isDownloading(false)
{
   // _downloader = std::shared_ptr<network::Downloader>(new network::Downloader());
    _currentPercent=0;
    _downloader->onTaskError = [this](const DownloadTask& task,
                                      int errorCode,
                                      int errorCodeInternal,
                                      const std::string& errorStr)
    {
        _isDownloading = false;
        _currentPercent=0;
        if(!_queue.empty()){
             _queue.erase(_queue.begin());
        }
        auto srcUrl = task.requestURL, storagePath = task.storagePath, identifier = task.identifier;
        Director::getInstance()->getScheduler()->performFunctionInCocosThread([this, srcUrl, storagePath, identifier]{
            sendCustomEvent("error", srcUrl, storagePath, identifier, 100);
        });
        
        //sendCustomEvent("error",task.requestURL,task.storagePath,task.identifier,100);
        
        
        if(_queue.empty()){
           // sendCustomEvent("complete",task.requestURL,task.storagePath,task.identifier,100);
            Director::getInstance()->getScheduler()->performFunctionInCocosThread([this, srcUrl, storagePath, identifier]{
                sendCustomEvent("complete", srcUrl, storagePath, identifier, 100);
            });
            
        }else{
            
            startLoadTask();
        }

        
    };
    
    // progress callback
    _downloader->onTaskProgress = [this](const DownloadTask& task,
                                         int64_t bytesReceived,
                                         int64_t totalBytesReceived,
                                         int64_t totalBytesExpected)
    {
        
        
        
        int percent = totalBytesExpected ? int(totalBytesReceived * 100 / totalBytesExpected) : 0;
        
       // CCLOG("c++ loading:%s  %d  %d", task.storagePath.c_str(),percent,(percent-_currentPercent));
        
        //don't send too many messages to js. jsb would be crash.
        if(  percent-_currentPercent<5){
            return;
        }
        _currentPercent=percent;
         //sendCustomEvent("loading", task.requestURL, task.storagePath, task.identifier, percent);
        auto srcUrl = task.requestURL, storagePath = task.storagePath, identifier = task.identifier;
        Director::getInstance()->getScheduler()->performFunctionInCocosThread([this, srcUrl, storagePath, identifier, percent]{
            std::string pstr;
            int2str(percent,pstr);
            sendCustomEvent("loading", srcUrl, storagePath, identifier, percent);
                   });
       
    };
    
    // after download package, do uncompress operation
    _downloader->onFileTaskSuccess = [this](const DownloadTask& task)
    {
        _isDownloading = false;
        _currentPercent=0;
        std::thread loadThread(&SimpleLoader::onItemLoadedThread,this,task.requestURL,task.storagePath,task.identifier,_loaderId);
        loadThread.detach();
       
    };

}

void SimpleLoader::onItemLoadedThread(std::string srcUrl,std::string storagePath,std::string identifier,std::string loaderId){
    //CCLOG("onItemLoaded >>>>>>>>>>> id:%s",identifier.c_str());
    
    // CCLOG("onItemLoadedThread1 ");
    
    const std::regex pattern("[^\\\\]*.[zip|rar|7zip]$");
    bool rs=std::regex_match (storagePath,  pattern );
    
    
    SimpleLoader *loader=SimpleLoader::getInstance(loaderId);
    if (rs==true  && loader->decompress(storagePath)) {
        
        FileUtils::getInstance()->removeFile(storagePath);
    }
    
    Director::getInstance()->getScheduler()->performFunctionInCocosThread([this,srcUrl,storagePath,identifier,loaderId]{
        SimpleLoader *loader=SimpleLoader::getInstance(loaderId);
        if(!loader->_queue.empty()){
            loader->_queue.erase(_queue.begin());
        }
    
        loader->sendCustomEvent("loaded",srcUrl,storagePath,identifier,100);
        if(loader->_queue.empty()){
            loader->sendCustomEvent("complete",srcUrl,storagePath,identifier,100);
        }else{
            
            loader->startLoadTask();
        }
    });
    
}

bool   SimpleLoader::isInQueue(std::string idOrUrl)
{
    
    
    for (auto it = _queue.begin(); it != _queue.end(); it++) {
        
        LoaderItem item = *it;
    
        if (item.identifier==idOrUrl || item.srcUrl==idOrUrl)
        {
            return true;
        }
    }
    
    return false;
    
    
}

SimpleLoader::~SimpleLoader(){
   // CC_SAFE_DELETE(_downloader);
    _downloader->onTaskError = (nullptr);
    _downloader->onFileTaskSuccess = (nullptr);
    _downloader->onTaskProgress = (nullptr);
   
}

void SimpleLoader::sendCustomEvent(std::string type,std::string srcUrl,std::string storagePath,std::string identifier,int percent){
    
//    auto director = Director::getInstance();
//    EventCustom *event = new EventCustom(_loaderId);
//    std::string percentStr;
//    int2str(percent,percentStr);
// 
//    map<string,string> data;
//    data["type"]=type;
//    data["percent"]=percentStr;
//    data["srcUrl"]=srcUrl;
//    data["storagePath"]=storagePath;
//    data["identifier"]=identifier;
//    data["loaderId"]=_loaderId;
//    event->setNativeData(&data);
    
    struct timeval nowTimeval;
    gettimeofday(&nowTimeval, nullptr);
    
  
   // cocos2d::Director::getInstance()->getScheduler()->schedule([&, type,srcUrl,storagePath,identifier,percent](float dt){
//     Director::getInstance()->getScheduler()->performFunctionInCocosThread([this,type,srcUrl,storagePath,identifier,percent]{
    
    std::string percentStr;
     int2str(percent,percentStr);
    std::string str=_loaderId+"Callback('"+type+","+identifier+","+srcUrl+","+percentStr+","+storagePath+"')";
   // CCLOG("call:%s",str.c_str());
    ScriptingCore::getInstance()->evalString(str.c_str());

    
    
//        auto director = Director::getInstance();
//        EventCustom *event = new EventCustom(_loaderId);
//        std::string percentStr;
//        int2str(percent,percentStr);
//        
//        map<string,string> data;
//        data["type"]=type;
//        data["percent"]=percentStr;
//        data["srcUrl"]=srcUrl;
//        data["storagePath"]=storagePath;
//        data["identifier"]=identifier;
//        data["loaderId"]=_loaderId;
//        event->setNativeData(&data);
//        
//        director->getEventDispatcher()->dispatchEvent(event);
    
    
    
    
        //CCLOG("send custom:%s  %s",type.c_str(),storagePath.c_str());
      
  //  }, this, 0, 0, 0.0, false, StringUtils::format("%s#%ld.%d", "SimpleLoader::sendCustomEvent", nowTimeval.tv_sec, nowTimeval.tv_usec));
//     });
    
//    director->getEventDispatcher()->dispatchEvent(&event);
   
}

void SimpleLoader::addItem(const std::string& srcUrl,
                           const std::string& storagePath,
                           const std::string& identifier/* = ""*/){
    
    LoaderItem item=*new LoaderItem();
    item.srcUrl=srcUrl;
    item.storagePath=storagePath;
    item.identifier=identifier;
    _queue.push_back(item);
   // _downloader->createDownloadFileTask(srcUrl,storagePath,identifier);
    
}

void SimpleLoader::removeItem(const std::string urlOrId){
    if(_queue.empty()) {
        return;
    }
   

    vector<LoaderItem>::iterator item;
    for(item=_queue.begin();item!=_queue.end();){
        if(item->srcUrl==urlOrId || item->identifier==urlOrId){
            return;
        }
    }
    
}

void SimpleLoader::startLoadTask(){
    
    
    if(_isDownloading==true || _queue.empty()) {
        return;
    }
   
    LoaderItem item=_queue[0];
    // Find file name and file extension
    unsigned long found = item.storagePath.find_last_of("/\\");
     string name ;
     string  path;
    if (found != std::string::npos)
    {
        
      name = item.storagePath.substr(found+1);
      path = item.storagePath.substr(0, found+1);
    }
    else
    {
        
        CCLOG("Invalid url or filename not exist error:%s ", item.storagePath.c_str());
        return;
    }
    
    _isDownloading=true;
    FileUtils::getInstance()->createDirectory(path);
    
    _downloader->createDownloadFileTask(item.srcUrl,item.storagePath,item.identifier);
    
}

void SimpleLoader::stopLoadTask(){
    
}

void SimpleLoader::setDelegate(SimpleLoaderDelegateProtocol *delegate){
    _delegate = delegate;
}






void SimpleLoader::int2str(const int &int_temp,std::string &string_temp)
{
    stringstream stream;
    stream<<int_temp;
    string_temp=stream.str();   //此处也可以用 stream>>string_temp
}

void SimpleLoader::setLoaderId(std::string loaderId){
    _loaderId=loaderId;

}

std::string SimpleLoader::basename(const std::string& path) 
{
    size_t found = path.find_last_of("/\\");
    
    if (std::string::npos != found)
    {
        return path.substr(0, found);
    }
    else
    {
        return path;
    }
}




bool SimpleLoader::decompress(const std::string &zip)
{
  
    // Find root path for zip file
    size_t pos = zip.find_last_of("/\\");
    if (pos == std::string::npos)
    {
        CCLOG("SimpleLoader : no root path specified for zip file %s\n", zip.c_str());
        return false;
    }
    const std::string rootPath = zip.substr(0, pos+1);
    
    // Open the zip file
    unzFile zipfile = unzOpen(zip.c_str());
    if (! zipfile)
    {
        CCLOG("SimpleLoader : can not open downloaded zip file %s\n", zip.c_str());
        return false;
    }
    
    // Get info about the zip file
    unz_global_info global_info;
    if (unzGetGlobalInfo(zipfile, &global_info) != UNZ_OK)
    {
        CCLOG("SimpleLoader : can not read file global info of %s\n", zip.c_str());
        unzClose(zipfile);
        return false;
    }
    
    // Buffer to hold data read from the zip file
    char readBuffer[BUFFER_SIZE];
    // Loop to extract all files.
    uLong i;
    for (i = 0; i < global_info.number_entry; ++i)
    {
        // Get info about current file.
        unz_file_info fileInfo;
        char fileName[MAX_FILENAME];
        if (unzGetCurrentFileInfo(zipfile,
                                  &fileInfo,
                                  fileName,
                                  MAX_FILENAME,
                                  NULL,
                                  0,
                                  NULL,
                                  0) != UNZ_OK)
        {
            CCLOG("SimpleLoader : can not read compressed file info\n");
            unzClose(zipfile);
            return false;
        }
        const std::string fullPath = rootPath + fileName;
        
        // Check if this entry is a directory or a file.
        const size_t filenameLength = strlen(fileName);
        const std::string pos_fileName = fileName;
        size_t pos_file = pos_fileName.find_last_of("/\\");
        const std::string dir = pos_fileName.substr(0, pos_file+1);
        
        if(!FileUtils::getInstance()->isDirectoryExist(rootPath + dir)) {
            if(!FileUtils::getInstance()->createDirectory(rootPath +dir)) {
            }
        }
        
        if (fileName[filenameLength-1] == '/')
        {
            //There are not directory entry in some case.
            //So we need to create directory when decompressing file entry
            if(!FileUtils::getInstance()->createDirectory(basename(fullPath))) {
                
                // Failed to create directory
                CCLOG("SimpleLoader : can not create directory %s\n", fullPath.c_str());
                unzClose(zipfile);
                return false;
            }
        }
        else
        {
            // Entry is a file, so extract it.
            // Open current file.
            if (unzOpenCurrentFile(zipfile) != UNZ_OK)
            {
                CCLOG("SimpleLoader : can not extract file %s\n", fileName);
                unzClose(zipfile);
                return false;
            }
            
            // Create a file to store current file.
            FILE *out = fopen(fullPath.c_str(), "wb");
            if (!out)
            {
                CCLOG("SimpleLoader : can not create decompress destination file %s\n", fullPath.c_str());
                unzCloseCurrentFile(zipfile);
                unzClose(zipfile);
                return false;
            }
            
            // Write current file content to destinate file.
            int error = UNZ_OK;
            do
            {
                error = unzReadCurrentFile(zipfile, readBuffer, BUFFER_SIZE);
                if (error < 0)
                {
                    CCLOG("SimpleLoader : can not read zip file %s, error code is %d\n", fileName, error);
                    fclose(out);
                    unzCloseCurrentFile(zipfile);
                    unzClose(zipfile);
                    return false;
                }
                if (error > 0)
                {
                    fwrite(readBuffer, error, 1, out);
                }
            } while(error > 0);
            
            fclose(out);
        }
        
        unzCloseCurrentFile(zipfile);
        
        // Goto next entry listed in the zip file.
        if ((i+1) < global_info.number_entry)
        {
            if (unzGoToNextFile(zipfile) != UNZ_OK)
            {
                CCLOG("SimpleLoader : can not read next file for decompressing\n");
                unzClose(zipfile);
                return false;
            }
        }
    }
    
    unzClose(zipfile);
    return true;
}

std::map<std::string,SimpleLoader*> SimpleLoader::_instance;

SimpleLoader* SimpleLoader::create(std::string loaderId )
{
    
    auto* loader = new (std::nothrow) SimpleLoader();
    loader->setLoaderId(loaderId);
    SimpleLoader::_instance[loaderId]=loader;
    loader->autorelease();
    return loader;
    
//    SimpleLoader* ret = new (std::nothrow) SimpleLoader();
//    if (ret)
//    {
//        ret->autorelease();
//    }
//    else
//    {
//        CC_SAFE_DELETE(ret);
//    }
//    return ret;
}


SimpleLoader*  SimpleLoader::getInstance(std::string loaderId){
    return SimpleLoader::_instance[loaderId];
}


//NS_CC_EXT_END;

