//
//  SimpleLoader.hpp
//  cocos2d_libs
//
//  Created by liuyi on 16/4/5.
//
//

#ifndef SimpleLoader_hpp
#define SimpleLoader_hpp

#include <string>
#include <vector>

#include "2d/CCNode.h"
#include "extensions/ExtensionMacros.h"
#include "extensions/ExtensionExport.h"
#include "network/CCDownloader.h"




namespace cocos2d { namespace network {
    class Downloader;
}}



//NS_CC_EXT_BEGIN

class SimpleLoaderDelegateProtocol;


class CC_EX_DLL SimpleLoader : public cocos2d::Ref
{
public:
    
    enum class ErrorCode
    {
        // Error caused by creating a file to store downloaded data
        CREATE_FILE,
        /** Error caused by network
         -- network unavailable
         -- timeout
         -- ...
         */
        NETWORK,
        /** There is not a new version
         */
        NO_NEW_VERSION,
        /** Error caused in uncompressing stage
         -- can not open zip file
         -- can not read file global information
         -- can not read file information
         -- can not create a directory
         -- ...
         */
        UNCOMPRESS,
    };
    
    struct LoaderItem{
        std::string srcUrl;
        std::string storagePath;
        std::string identifier;
        int percent;
        
        
    };
    
    struct LoadingItem{
        std::string srcUrl;
        std::string storagePath;
        std::string identifier;
        int percent;
        std::string loaderId;
        
        
    };

    SimpleLoader();
    ~SimpleLoader();
    
    static std::map<std::string,SimpleLoader*> _instance;
    static SimpleLoader* getInstance(std::string loaderId);
    
    typedef std::function<void(int)> ErrorCallback;
    typedef std::function<void(int)> ProgressCallback;
    typedef std::function<void(void)> SuccessCallback;
    
    LoadingItem *loadingItem;
    
    std::string *info;
    //static SimpleLoader* create( ErrorCallback errorCallback, ProgressCallback progressCallback, SuccessCallback successCallback );
    static SimpleLoader* create( std::string loaderId);
    
    
    void addItem(const std::string& srcUrl,
                 const std::string& storagePath,
                 const std::string& identifier/* = ""*/);
    void removeItem(const std::string url);
    void startLoadTask();
    void stopLoadTask();
    void setDelegate(SimpleLoaderDelegateProtocol *delegate);
    void setLoaderId(std::string loaderId);
    void sendCustomEvent(std::string type,std::string srcUrl,std::string storagePath,std::string identifier,int percent);
    bool decompress(const std::string &zip);
    std::string basename(const std::string& path);
    
    void onItemLoadedThread(std::string srcUrl,std::string storagePath,std::string identifier ,std::string loaderId);
    bool isInQueue(std::string idOrUrl);
    
     std::vector<struct LoaderItem> _queue;
protected:

    
    


private:
    cocos2d::network::Downloader* _downloader;
    //! Downloader
//    std::shared_ptr<network::Downloader> _downloader;

    unsigned int _connectionTimeout;
    std::string _loaderId;
    SimpleLoaderDelegateProtocol *_delegate;
    
    bool _isDownloading;
    int _currentPercent;
    bool _shouldDeleteDelegateWhenExit;
   
    
    void _doLoad(LoaderItem item);
    
    void int2str(const int &int_temp,std::string &string_temp);
    
    
    
};


class SimpleLoaderDelegateProtocol
{
public:
    virtual ~SimpleLoaderDelegateProtocol(){};
public:
    /* @brief Call back function for error
     @param errorCode Type of error
     * @js NA
     * @lua NA
     */
    virtual void onError(SimpleLoader::ErrorCode errorCode) {};
    /** @brief Call back function for recording downloading percent
     @param percent How much percent downloaded
     @warning    This call back function just for recording downloading percent.
     AssetsManager will do some other thing after downloading, you should
     write code in onSuccess() after downloading.
     * @js NA
     * @lua NA
     */
    virtual void onProgress(int percent) {};
    /** @brief Call back function for success
     * @js NA
     * @lua NA
     */
    virtual void onSuccess() {};
};




//NS_CC_EXT_END;
#endif /* SimpleLoader_hpp */
