//
//  jsb_cocos2dx_simpleLoader_auto.cpp
//  cocos2d_js_bindings
//
//  Created by liuyi on 16/4/5.
//
//

#include "jsb_cocos2dx_simpleLoader_auto.hpp"
#include "cocos2d_specifics.hpp"
#include "cocos-ext.h"
#include "jsapi.h"
#include "jsb_cocos2dx_auto.hpp"
#include "SimpleLoader.hpp"


template<class T>
static bool dummy_constructor(JSContext *cx, uint32_t argc, jsval *vp) {
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    JS::RootedValue initializing(cx);
    bool isNewValid = true;
    JS::RootedObject global(cx, ScriptingCore::getInstance()->getGlobalObject());
    isNewValid = JS_GetProperty(cx, global, "initializing", &initializing) && initializing.toBoolean();
    if (isNewValid)
    {
        TypeTest<T> t;
        js_type_class_t *typeClass = nullptr;
        std::string typeName = t.s_name();
        auto typeMapIter = _js_global_type_map.find(typeName);
        CCASSERT(typeMapIter != _js_global_type_map.end(), "Can't find the class type!");
        typeClass = typeMapIter->second;
        CCASSERT(typeClass, "The value is null.");
        
        JS::RootedObject proto(cx, typeClass->proto.ref());
        JS::RootedObject parent(cx, typeClass->parentProto.ref());
        JS::RootedObject _tmp(cx, JS_NewObject(cx, typeClass->jsclass, proto, parent));
        
        args.rval().set(OBJECT_TO_JSVAL(_tmp));
        return true;
    }
    
    JS_ReportError(cx, "Constructor for the requested class is not available, please refer to the API reference.");
    return false;
}

static bool empty_constructor(JSContext *cx, uint32_t argc, jsval *vp) {
    return false;
}

static bool js_is_native_obj(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    args.rval().setBoolean(true);
    return true;
}

 JSClass * jsb_cocos2dx_extension_SimpleLoader_class;
 JSObject * jsb_cocos2dx_extension_SimpleLoader_prototype;





bool js_cocos2dx_extension_SimpleLoader_create(JSContext *cx,uint32_t argc, jsval *vp){
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
   
    bool ok = true;
    if(argc==1){
        std::string arg0;
        ok &= jsval_to_std_string(cx, args.get(0), &arg0);
        JSB_PRECONDITION2(ok, cx, false, "js_cocos2dx_extension_SimpleLoader_create : Error processing arguments 1");
        
        SimpleLoader* ret =  SimpleLoader::create(arg0);
        jsval jsret = JSVAL_NULL;
        do {
            if (ret)
            {
               jsret=OBJECT_TO_JSVAL(js_get_or_create_jsobject<SimpleLoader>(cx,ret));
           }
            else
            {
                jsret = JSVAL_NULL;
            }
        }while(0);
        
        args.rval().set(jsret);
        return true;
    }
    return false;
}

bool js_cocos2dx_extension_SimpleLoader_addItem(JSContext *cx,uint32_t argc, jsval *vp){
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    
    SimpleLoader* cobj = (SimpleLoader *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_cocos2dx_extension_SimpleLoader_addItem : Invalid Native Object");
    
    if (argc == 3) {
        std::string arg0;
        std::string arg1;
        std::string arg2;
        
        ok &= jsval_to_std_string(cx, args.get(0), &arg0);
        JSB_PRECONDITION2(ok, cx, false, "js_cocos2dx_extension_SimpleLoader_addItem : Error processing arguments 1");
        
        ok &= jsval_to_std_string(cx, args.get(1), &arg1);
        JSB_PRECONDITION2(ok, cx, false, "js_cocos2dx_extension_SimpleLoader_addItem : Error processing arguments 2");
        
        ok &= jsval_to_std_string(cx, args.get(2), &arg2);
        JSB_PRECONDITION2(ok, cx, false, "js_cocos2dx_extension_SimpleLoader_addItem : Error processing arguments 3");
     
         cobj->addItem(arg0,arg1,arg2);
        return true;
    }
    
    
    JS_ReportError(cx, "js_cocos2dx_extension_SimpleLoader_addItem : wrong number of arguments: %d, was expecting %d", argc, 3);
    return false;
}

bool js_cocos2dx_extension_SimpleLoader_removeItem(JSContext *cx,uint32_t argc, jsval *vp){
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    SimpleLoader* cobj = (SimpleLoader *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_cocos2dx_extension_SimpleLoader_addItem : Invalid Native Object");
    
    if (argc == 1) {
        std::string arg0;
        std::string arg1;
        std::string arg2;
        
        ok &= jsval_to_std_string(cx, args.get(0), &arg0);
        JSB_PRECONDITION2(ok, cx, false, "js_cocos2dx_extension_SimpleLoader_addItem : Error processing arguments 1");
        
         cobj->removeItem(arg0);
        return true;
    }
    
    
    JS_ReportError(cx, "js_cocos2dx_extension_SimpleLoader_addItem : wrong number of arguments: %d, was expecting %d", argc, 3);
    return false;
}

bool js_cocos2dx_extension_SimpleLoader_stopLoadTask(JSContext *cx,uint32_t argc, jsval *vp){
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
     
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    SimpleLoader* cobj = (SimpleLoader *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_cocos2dx_extension_SimpleLoader_stopLoadTask : Invalid Native Object");
     cobj->stopLoadTask();
    return false;
}

bool js_cocos2dx_extension_SimpleLoader_startLoadTask(JSContext *cx,uint32_t argc, jsval *vp){
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    SimpleLoader* cobj = (SimpleLoader *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_cocos2dx_extension_SimpleLoader_startLoadTask : Invalid Native Object");
     cobj->startLoadTask();
    return false;
}

bool js_cocos2dx_extension_SimpleLoader_isInQueue(JSContext *cx,uint32_t argc, jsval *vp){
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    SimpleLoader* cobj = (SimpleLoader *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_cocos2dx_extension_SimpleLoader_startLoadTask : Invalid Native Object");
    
    if(argc==1){
        std::string arg0;
        bool ok =true;
        ok &= jsval_to_std_string(cx, args.get(0), &arg0);
        JSB_PRECONDITION2(ok, cx, false, "js_cocos2dx_extension_SimpleLoader_addItem : Error processing arguments 1");
        bool ret= cobj->isInQueue(arg0);
         args.rval().setBoolean(ret);
        return true;
    }
    
    return false;
    
    
}



void js_cocos2dx_extension_SimpleLoader_finalize(JSFreeOp *fop, JSObject *obj){
    CCLOGINFO("jsbindings: finalizing JS object %p (SimpleLoader)", obj);
    js_proxy_t* nproxy;
    js_proxy_t* jsproxy;
    jsproxy = jsb_get_js_proxy(obj);
    if (jsproxy) {
        nproxy = jsb_get_native_proxy(jsproxy->ptr);
        
        SimpleLoader *nobj = static_cast< SimpleLoader *>(nproxy->ptr);
        if (nobj)
            delete nobj;
        
        jsb_remove_proxy(nproxy, jsproxy);
    }
}


bool js_cocos2dx_extension_SimpleLoader_constructor(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    js_type_class_t *typeClass = nullptr;
    SimpleLoader * cobj=new SimpleLoader();
    JS::RootedObject proto(cx, typeClass->proto.ref());
    JS::RootedObject parent(cx, typeClass->parentProto.ref());
    JS::RootedObject obj(cx, JS_NewObject(cx, typeClass->jsclass, proto, parent));
    args.rval().set(OBJECT_TO_JSVAL(obj));
    // link the native object with the javascript object
    js_proxy_t* p = jsb_new_proxy(cobj, obj);
    if (JS_HasProperty(cx, obj, "_ctor", &ok) && ok)
        ScriptingCore::getInstance()->executeFunctionWithOwner(OBJECT_TO_JSVAL(obj), "_ctor", args);
    return true;
}





void js_register_cocos2dx_extension_SimpleLoader(JSContext *cx, JS::HandleObject global){
    jsb_cocos2dx_extension_SimpleLoader_class = (JSClass *)calloc(1, sizeof(JSClass));
    jsb_cocos2dx_extension_SimpleLoader_class->name = "SimpleLoader";
    jsb_cocos2dx_extension_SimpleLoader_class->addProperty = JS_PropertyStub;
    jsb_cocos2dx_extension_SimpleLoader_class->delProperty = JS_DeletePropertyStub;
    jsb_cocos2dx_extension_SimpleLoader_class->getProperty = JS_PropertyStub;
    jsb_cocos2dx_extension_SimpleLoader_class->setProperty = JS_StrictPropertyStub;
    jsb_cocos2dx_extension_SimpleLoader_class->enumerate = JS_EnumerateStub;
    jsb_cocos2dx_extension_SimpleLoader_class->resolve = JS_ResolveStub;
    jsb_cocos2dx_extension_SimpleLoader_class->convert = JS_ConvertStub;
    jsb_cocos2dx_extension_SimpleLoader_class->finalize = js_cocos2dx_extension_SimpleLoader_finalize;
    jsb_cocos2dx_extension_SimpleLoader_class->flags = JSCLASS_HAS_RESERVED_SLOTS(2);
    
    static JSPropertySpec properties[] = {
        JS_PSG("__nativeObj", js_is_native_obj, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        
        JS_PS_END
    };
    
    static JSFunctionSpec funcs[] = {
        JS_FN("startLoadTask", js_cocos2dx_extension_SimpleLoader_startLoadTask,0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("stopLoadTask", js_cocos2dx_extension_SimpleLoader_stopLoadTask,0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("addItem", js_cocos2dx_extension_SimpleLoader_addItem,1, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("removeItem", js_cocos2dx_extension_SimpleLoader_removeItem,0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("isInQueue", js_cocos2dx_extension_SimpleLoader_isInQueue, 0, JSPROP_ENUMERATE | JSPROP_PERMANENT),
        JS_FN("retain", js_cocos2dx_retain, 0, JSPROP_ENUMERATE | JSPROP_PERMANENT),
        JS_FN("release", js_cocos2dx_release, 0, JSPROP_ENUMERATE | JSPROP_PERMANENT),
        JS_FS_END
    };
    
    static JSFunctionSpec st_funcs[] = {
        JS_FN("create", js_cocos2dx_extension_SimpleLoader_create, 3, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        
        JS_FS_END
    };
    
    JS::RootedObject parent_proto(cx, jsb_cocos2d_Node_prototype);
    jsb_cocos2dx_extension_SimpleLoader_prototype = JS_InitClass(
                                                                cx, global,
                                                                //JS::NullPtr(), // parent proto
                                                                 parent_proto,
                                                                jsb_cocos2dx_extension_SimpleLoader_class,
                                                                js_cocos2dx_extension_SimpleLoader_constructor, 0,
                                                                properties,
                                                                funcs,
                                                                NULL, // no static properties
                                                                st_funcs);
    // make the class enumerable in the registered namespace
    //  bool found;
    //FIXME: Removed in Firefox v27
    
    // add the proto and JSClass to the type->js info hash table
    TypeTest<SimpleLoader> t;
    js_type_class_t *p;
    std::string typeName = t.s_name();
    if (_js_global_type_map.find(typeName) == _js_global_type_map.end())
    {
        p = (js_type_class_t *)malloc(sizeof(js_type_class_t));
        p->jsclass = jsb_cocos2dx_extension_SimpleLoader_class;
        p->proto.ref() = jsb_cocos2dx_extension_SimpleLoader_prototype;
        p->parentProto.empty();
        _js_global_type_map.insert(std::make_pair(typeName, p));
    }
}//end register


void register_SimpleLoader(JSContext* cx, JS::HandleObject obj)
{
    JS::RootedObject ns(cx);
    get_or_create_js_obj(cx, obj, "cc", &ns);
    js_register_cocos2dx_extension_SimpleLoader(cx,ns);

}


