//
// Created by ddkids on 16/1/22.
//


#include "cocos2d.h"
#include "scripting/js-bindings/manual/ScriptingCore.h"
#include "spine/spine-cocos2dx.h"
#include <map>


using namespace std;
using namespace spine;
using namespace cocos2d;

//==========================Spine==========================
extern JSObject* jsb_spine_SkeletonRenderer_prototype;

bool jsb_manual_cocos2dx_spine_SkeletonRenderer_setAttachment(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    
    JS::RootedObject obj(cx);
    spine::SkeletonRenderer* cobj = NULL;
    obj = args.thisv().toObjectOrNull();
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    cobj = (spine::SkeletonRenderer *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_cocos2dx_spine_SkeletonRenderer_setAttachment : Invalid Native Object");
    do {
        if (argc == 2) {
            std::string arg0;
            ok &= jsval_to_std_string(cx, args.get(0), &arg0);
            if (!ok) { ok = true; break; }
            const char* arg1 = nullptr;
            std::string arg1_tmp; ok &= jsval_to_std_string(cx, args.get(1), &arg1_tmp); arg1 = arg1_tmp.empty()? nullptr : arg1_tmp.c_str();
            if (!ok) { ok = true; break; }
            bool ret = cobj->setAttachment(arg0, arg1);
            jsval jsret = JSVAL_NULL;
            jsret = BOOLEAN_TO_JSVAL(ret);
            args.rval().set(jsret);
            return true;
        }
    } while(0);
    
    JS_ReportError(cx, "js_cocos2dx_spine_SkeletonRenderer_setAttachment : wrong number of arguments");
    return false;
}


extern JSObject *jsb_cocos2d_Node_prototype;
bool js_cocos2dx_Node_visitWithParentTransform(JSContext *cx, uint32_t argc, jsval *vp)
{
    
   Node* node = nullptr;
    
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    JS::RootedObject obj(cx);
    obj.set(args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    node = (cocos2d::Node *)(proxy ? proxy->ptr : nullptr);
    EventCustom * event=new EventCustom("custom_test");
    
    map<string,string> data;
    data["text"]="I am from cpp";

    
    event->setUserData(&data);
    
   auto director = Director::getInstance();
   // director->getEventDispatcher()->dispatchEvent(event);
    
    director->getEventDispatcher()->dispatchCustomEvent("custom_test",&data);
    return true;
    
 
    
}




void register_all_manual_functions(JSContext *cx, JS::HandleObject global) {
    
 
    
    //====================Node====================================
    JS::RootedObject node(cx, jsb_cocos2d_Node_prototype);
    JS_DefineFunction(cx, node, "sendEvent", js_cocos2dx_Node_visitWithParentTransform, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE);
    
 
    
}



