
var HelloWorldLayer = cc.Layer.extend({
    sprite:null,
    ctor:function () {
        //////////////////////////////
        // 1. super init first
        this._super();

        /////////////////////////////
        // 2. add a menu item with "X" image, which is clicked to quit the program
        //    you may modify it.
        // ask the window size
        var size = cc.winSize;

        /////////////////////////////
        // 3. add your codes below...
        // add a label shows "Hello World"
        // create and initialize a label
        var helloLabel = new cc.LabelTTF("custom event bug example:\n", "Arial", 18);
        helloLabel.setAnchorPoint(0.5,1);
        helloLabel.setDimensions(600,600);

        // position the label on the center of the screen
        helloLabel.x = size.width / 2;
        helloLabel.y = size.height / 2 + 200;
        // add the label as a child to this layer
        this.addChild(helloLabel, 5);
        this.helloLabel=helloLabel;


        this.cppCustomEventTest();
        this.jsCustomEventTest();

        return true;
    },
   showLog:function(text){
        var _self=this;
         _self.helloLabel.setString(_self.helloLabel.getString()+"\n"+text);
    },
    cppCustomEventTest:function(){
        var _self=this;
        _self.showLog("\n--------cpp custom event  userdata is empty -------");
         var listener = cc.EventListener.create({
            event: cc.EventListener.CUSTOM,
            eventName:"custom_test",//event name is the same as cpp
            callback: function (evt) {
                 _self.showLog("Got custom event from cpp！");
                   
                    var msg = evt.getUserData();
                    if(msg==null){
                        _self.showLog("But user data is null...,Should print \"I am from cpp\"");
                         
                        return;
                    }
                    _self.showLog("Wow! Got user data!!");
                       
                    _self.showLog(msg.text);//Should print "I am from cpp";
                     
            }
        });

         cc.eventManager.addListener(listener, 2);


        var node=new cc.Node();
        _self.addChild(node);
        _self.sendEvent();//send a custom event, set user data in cpp code.(JUST FOR SIMPLE TEST);


       
    },
    jsCustomEventTest:function(){
        var _self=this;
         _self.showLog("\n--------js custom event is correct-------");
         var listener = cc.EventListener.create({
            event: cc.EventListener.CUSTOM,
            eventName:"js_custom_test",//event name is the same as cpp
            callback: function (evt) {
                 _self.showLog("Got custom event from js");
                   
                    var msg = evt.getUserData();
                    if(msg==null){
                        _self.showLog("But user data is null...,Should print \"I am from js\"");
                         
                        return;
                    }
                    _self.showLog("Wow! Got user data from js!!");
                       
                    _self.showLog(msg.text);//Should print "I am from cpp";
                     
            }
        });

         cc.eventManager.addListener(listener, 2);

          var evt = new cc.EventCustom("js_custom_test");
          evt.setUserData({text:"I am from js"});
          cc.eventManager.dispatchEvent(evt);

    }

    
});

var HelloWorldScene = cc.Scene.extend({
    onEnter:function () {
        this._super();
        var layer = new HelloWorldLayer();
        this.addChild(layer);
       
    }
                                      
});

