const STANDUP = 1;
const SITDOWN = 2;
cc.Class({
    extends: cc.Component,

    properties: {
        _handCard: [],
        cardPrefab: cc.Prefab,
        cardArr: {
            default: [],
            type: cc.SpriteFrame
        }
    },

    _getCardForTouch: function (touch, cardArr) {
        for (var k in cardArr) {
            var box = cardArr[k].getBoundingBox();
            if (cc.rectContainsPoint(box, touch)) {
                cardArr[k].isChiose = true;
                // cardArr[k].opacity = 155;
                cardArr[k].color = new cc.Color(150,150,150);
                return true;
            } 
        }
    },

    touchBegan: function (event) {
        event.stopPropagation();
        var touches = event.getTouches();
        var touchLoc = touches[0].getLocation();
        this._getCardForTouch(touchLoc, this._handCard);
    },

    touchMoved: function (event) {
    },

    touchCancel: function () {

    },

    touchEnd: function (event) {
        var touches = event.getTouches();
        var touchLoc = touches[0].getLocation();
        for (var k in this._handCard) {
            // this._handCard[k].opacity = 255;
            this._handCard[k].color = new cc.Color(255,255,255);
            if (this._handCard[k].isChiose === true) {
                this._handCard[k].isChiose = false;
                if (this._handCard[k].status === SITDOWN) {
                    this._handCard[k].status = STANDUP;
                    this._handCard[k].y += 20;
                } else {
                    this._handCard[k].status = SITDOWN;
                    this._handCard[k].y -= 20;
                }
            }
        }
    },

    onTouchEvent: function () {
        this.node.on(cc.Node.EventType.TOUCH_START, this.touchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.touchCancel, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.touchEnd, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.touchMoved, this);
    },

    offTouchEvent: function () {
        this.node.off(cc.Node.EventType.TOUCH_START, this.touchBegan, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this.touchCancel, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this.touchEnd, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this.touchMoved, this);
    },

    // use this for initialization
    onLoad: function () {
        for (var i = 0; i < 3; i++) {
            var cardPrefab = cc.instantiate(this.cardPrefab);
            cardPrefab.getComponent(cc.Sprite).spriteFrame = this.cardArr[i];
            cardPrefab.status = SITDOWN;
            cardPrefab.isChiose = false;
            this._handCard.push(cardPrefab);
        }

        var drawX = 1280 / 2 - ((this._handCard.length - 1) / 2) * 60;
        for (let i = 0 ; i < this._handCard.length ; i++ ) {
            this.node.addChild(this._handCard[i]);
            this._handCard[i].position = cc.p(drawX + i * 60, 120);
        }
        this.onTouchEvent();
    }
    // called every frame, uncomment this function to activate update callback
    // update: function (dt) {

    // },
});
