cc.Class({
    extends: cc.Component,

    properties: {
        childA: cc.Sprite,
        ndLayout: cc.Node,
        arr: [],
    },

    // use this for initialization
    onLoad: function () {
        this.addChildren();
        this.getChildrenPos();
    },

    // called every frame
    update: function (dt) {

    },


//-325, -175, -25, 125
    addChildren: function () {
        for(var i= 0; i< 4; i++){
            var nd = new cc.Node();
            var sp = nd.addComponent(cc.Sprite);
            sp.spriteFrame = this.childA.spriteFrame.clone();
            this.ndLayout.addChild(nd);
            this.arr.push(nd);
        }
    },

    getChildrenPos: function () {
        for(var k in this.arr){
            var node = this.arr[k];
            var posX = node.getPositionX();
            cc.log("child "+ k + "of layout positionX = "+ posX);
        }
    },


    /**
     * 从程序的log可以看出，在程序里面给layout添加四个节点之后，用getPositionX方法获取四个字节点的横坐标值， 四个子节点输出的坐标x值全部是0。
     * 然而如果是直接在编辑器里面给layout添加四个字节点，获取到的横坐标值确不是0。所以，可以知道由程序里面给layout动态添加的字节点的坐标值有误
     */
});
