cc.Class({
    "extends": cc.Component,

    properties: {
        toolStatus: 1, //工具状态 1:画笔 2:橡皮擦
        graphics: cc.Node
    },

    // use this for initialization
    onLoad: function onLoad() {

        cc.eventManager.addListener({
            event: cc.EventListener.TOUCH_ONE_BY_ONE,
            onTouchBegan: this.onTouchBegan.bind(this),
            onTouchMoved: this.onTouchMoved.bind(this),
            onTouchEnded: this.onTouchEnded.bind(this)
        }, this.node);

        var rt = new cc.RenderTexture(this.node.width, this.node.height);
        this.node._sgNode.addChild(rt);
        this.rt = rt;

        var draw = new cc.DrawNode();
        draw.drawSegment(cc.p(50, 50), cc.p(250, 250), 2, cc.color(255, 0, 255, 255));
        this.node._sgNode.addChild(draw);

        //在renderTexture上会变糊。。。直接用draw不会

        // var hehe = new cc.RenderTexture(this.node.width, this.node.height);
        // this.node._sgNode.addChild(hehe);
        // hehe.begin();
        // draw.visit();
        // hehe.end();

        // draw.removeFromParent();
    },

    onTouchBegan: function onTouchBegan(touch, event) {
        if (this.toolStatus == 1) {
            var touchLoc = touch.getLocation();
            touchLoc = this.node.convertToNodeSpaceAR(touchLoc);
            touchLoc.x += this.node.width / 2;
            touchLoc.y += this.node.height / 2;

            this.originPoint = touchLoc;
        }

        return true;
    },

    onTouchMoved: function onTouchMoved(touch, event) {
        var touchLoc = touch.getLocation();
        touchLoc = this.node.convertToNodeSpaceAR(touchLoc);
        //坐标系统由于是cocos2dx的，所以计算一下
        touchLoc.x += this.node.width / 2;
        touchLoc.y += this.node.height / 2;
        if (this.toolStatus == 1) {

            var draw = new cc.DrawNode();
            draw.drawSegment(this.originPoint, touchLoc, 2, cc.color(255, 0, 255, 255));

            this.rt.begin();
            draw.visit();
            this.rt.end();

            this.originPoint = touchLoc;
        } else if (this.toolStatus == 2) {
            var e1 = new cc.DrawNode();
            e1.drawDot(touchLoc, 20, cc.color(255, 255, 255, 255));
            e1.setBlendFunc(cc.ZERO, cc.ONE_MINUS_SRC_ALPHA);
            var rt = this.rt;
            rt.begin();
            e1.visit();
            rt.end();
            cc.log(rt);
        }
    },

    onTouchEnded: function onTouchEnded(touch, event) {},

    eraserButtonClick: function eraserButtonClick() {
        this.toolStatus = 2;
    },
    penButtonClick: function penButtonClick() {
        this.toolStatus = 1;
    }
});