"use strict";
cc._RFpush(module, '280c3rsZJJKnZ9RqbALVwtK', 'game');
// Script/game.js

cc.Class({
    "extends": cc.Component,
    properties: {
        T1: {
            "default": null,
            type: cc.Node
        },
        adc1: {
            "default": null,
            type: cc.Node
        },
        ap1: {
            "default": null,
            type: cc.Node
        },
        T2: {
            "default": null,
            type: cc.Node
        },
        adc2: {
            "default": null,
            type: cc.Node
        },
        ap2: {
            "default": null,
            type: cc.Node
        },
        T1PB: {
            "default": null,
            type: cc.ProgressBar
        },
        adc1PB: {
            "default": null,
            type: cc.ProgressBar
        },
        ap1PB: {
            "default": null,
            type: cc.ProgressBar
        },
        T2PB: {
            "default": null,
            type: cc.ProgressBar
        },
        adc2PB: {
            "default": null,
            type: cc.ProgressBar
        },
        ap2PB: {
            "default": null,
            type: cc.ProgressBar
        },
        winner: {
            "default": null,
            type: cc.Label
        },
        missile: {
            "default": null,
            type: cc.Node
        },
        btLabel: {
            "default": null,
            type: cc.Label
        },
        loadingLayout: {
            "default": null,
            type: cc.Node
        },
        speedBt: cc.Button,
        T1NLButton: cc.Button,
        adc1NLButton: cc.Button,
        ap1NLButton: cc.Button,
        T1NL: {
            "default": null,
            type: cc.ProgressBar
        },
        adc1NL: {
            "default": null,
            type: cc.ProgressBar
        },
        ap1NL: {
            "default": null,
            type: cc.ProgressBar
        },
        MaxMoveSpeed: 0,
        T1Life: 1000,
        T2Life: 1000,
        adc1Life: 500,
        adc2Life: 500,
        ap1Life: 500,
        ap2Life: 500,
        isFighter: 1,
        display: cc.Label
    },
    //得到Sprite的X,Y,Width,Height
    getInfo: function getInfo(role) {
        var X = role.x;
        var Y = role.y;
        var Width = role.width;
        var Height = role.height;
        // array[0] = X;
        // array[1] = Y;
        // array[2] = Width;
        // array[3] = Height;
        var array = new Array(X, Y, Width, Height);
        return array;
    },
    //两个Sprite之间的距离
    range: function range(role1, role2) {
        var arr1 = this.getInfo(role1);
        var arr2 = this.getInfo(role2);
        if (arr1[0] < arr2[0]) {
            var oneToTwoX = arr2[0] - arr1[0] - arr2[2] / 2 - arr1[2] / 2;
            var oneToTwoY = arr2[1] - arr1[1] - arr2[3] / 2 + arr1[3] / 2;
            var array = new Array(oneToTwoX, oneToTwoY);
            return array;
        } else {
            var twoToOneX = arr2[0] - arr1[0] + arr2[2] / 2 + arr1[2] / 2;
            var twoToOneY = arr2[1] - arr1[1] - arr2[3] / 2 + arr1[3] / 2;
            var array1 = new Array(twoToOneX, twoToOneY);
            return array1;
        }
    },
    //肇事者
    isWrecker: function isWrecker() {
        if (this.isFighter == 1) {
            while (this.FactionArrayOne[this.Awrecker].currlife <= 0) {
                this.Awrecker++;
            }
            var xx = this.FactionArrayOne[this.Awrecker];
            this.Awrecker++;
            if (this.Awrecker > this.FactionArrayOne.length - 1) {
                this.Awrecker = 0;
            }
            this.isFighter = 2;
            return xx;
        } else {
            while (this.FactionArrayTwo[this.Bwrecker].currlife <= 0) {
                this.Bwrecker++;
            }
            var ss = this.FactionArrayTwo[this.Bwrecker];
            this.Bwrecker++;
            if (this.Bwrecker > this.FactionArrayTwo.length - 1) {
                this.Bwrecker = 0;
            }
            this.isFighter = 1;
            return ss;
        }
    },
    //受害人
    isSufferer: function isSufferer() {
        if (this.isFighter == 1) {
            if (this.FactionArrayOne[this.Asufferer].currlife > 0) {
                return this.FactionArrayOne[this.Asufferer];
            } else {
                this.Asufferer++;
                return this.FactionArrayOne[this.Asufferer];
            }
        } else {
            if (this.FactionArrayTwo[this.Bsufferer].currlife > 0) {
                return this.FactionArrayTwo[this.Bsufferer];
            } else {
                this.Bsufferer++;
                return this.FactionArrayTwo[this.Bsufferer];
            }
        }
    },
    //随机数，扣血量
    GetRandomNum: function GetRandomNum(Min, Max) {
        var Range = Max - Min;
        var Rand = Math.random();
        this.Kblood = Min + Math.round(Rand * Range);
    },
    move: function move(role1, role2) {
        var self = this;
        var array = self.range(role1, role2);
        var moveT = cc.moveBy(self.MaxMoveSpeed, cc.p(array[0], array[1]));
        var delay = cc.delayTime(self.fightAnimTime);
        var moveBac = cc.moveBy(self.MaxMoveSpeed, cc.p(-array[0], -array[1]));
        var callBack = cc.callFunc(function () {
            var animState = self.animCtrl.playAdditive();
            animState.speed = self.animSpeed;
            self.kLife();
            //每次攻击加0.2能量
            for (var i = 0; i < self.FactionArrayOne.length; i++) {
                if (role1 == self.FactionArrayOne[i]) {
                    role1.NL.progress += 0.3;
                    if (role1.NL.progress > 1) {
                        role1.NL.progress = 1;
                    }
                } else if (role2 == self.FactionArrayOne[i]) {
                    role2.NL.progress += 0.2;
                    if (role2.NL.progress > 1) {
                        role2.NL.progress = 1;
                    }
                }
            }
        }, self);
        var mBCallBack = cc.callFunc(function () {
            if (self.isAuto == 0) {
                if (self.isT1FDZ == 0 && self.isAdc1FDZ == 0 && self.isAp1FDZ == 0) {
                    self.fight();
                } else {
                    if (self.isT1FDZ == 1) {
                        self.HSG(self.T1);
                        self.isT1FDZ = 0;
                    } else if (self.isAdc1FDZ == 1) {
                        self.HSG(self.adc1);
                        self.isAdc1FDZ = 0;
                    } else {
                        self.HSG(self.ap1);
                        self.isAp1FDZ = 0;
                    }
                }
            } else {
                if (self.T1.NL.progress == 1 && self.T1.currlife > 0) {
                    self.HSG(self.T1);
                } else if (self.adc1.NL.progress == 1 && self.adc1.currlife > 0) {
                    self.HSG(self.adc1);
                } else if (self.ap1.NL.progress == 1 && self.ap1.currlife > 0) {
                    self.HSG(self.ap1);
                } else {
                    self.fight();
                }
            }
        }, self);
        var spawn = cc.spawn(callBack, delay);
        var action = cc.sequence(moveT, spawn, moveBac, mBCallBack);
        return action;
    },
    fireTo: function fireTo(role) {
        var self = this;
        var array = self.range(self.missile, role);
        var moveT = cc.moveBy(self.MaxMoveSpeed, cc.p(array[0], array[1]));
        var moveBac = cc.moveBy(0, cc.p(-array[0], -array[1]));
        var callBack = cc.callFunc(function () {
            self.kLife();
            self.ap1.NL.progress += 0.3;
            if (self.ap1.NL.progress > 1) {
                self.ap1.NL.progress = 1;
            }
            self.missile.opacity = 0;
        }, self);
        var mbCallback = cc.callFunc(function () {
            if (self.isAuto == 0) {
                if (self.isAp1FDZ == 0) {
                    self.fight();
                } else {
                    self.HSG(self.ap1);
                    self.isAp1FDZ = 0;
                }
            } else {
                if (self.ap1.NL.progress == 1 && self.ap1.currlife > 0) {
                    self.HSG(self.ap1);
                    self.ap1.NL.progress = 0;
                } else {
                    self.fight();
                }
            }
        }, self);
        var action = cc.sequence(moveT, callBack, moveBac, mbCallback);
        if (self.fightSpeed) {
            var ac = cc.speed(action, self.fightSpeed);
        }
        return ac;
    },

    AToB: function AToB(A, B) {
        if (this.fightSpeed) {
            var ac = cc.speed(this.move(A, B), this.fightSpeed);
        }
        A.runAction(ac);
    },
    //战斗
    fight: function fight() {
        if (this.gameOver == 0) {
            var wrecker = this.isWrecker();
            var sufferer = this.isSufferer();
            this.animCtrl = wrecker.getComponent(cc.Animation);
            if (wrecker == this.ap1) {
                var animState = this.animCtrl.playAdditive();
                //导弹
                this.missile.opacity = 255;
                var missileAnim = this.missile.getComponent(cc.Animation);
                var misState = missileAnim.playAdditive();
                animState.speed = this.animSpeed;
                misState.speed = this.animSpeed;
                this.missile.runAction(this.fireTo(sufferer));
            } else {
                this.AToB(wrecker, sufferer);
            }
        }
    },
    //扣血
    kLife: function kLife() {
        //随机数
        this.GetRandomNum(100, 300);
        var sufferer = this.isSufferer();
        sufferer.currlife -= this.Kblood;
        log(sufferer.currlife);
        sufferer.ProgressBar.progress = sufferer.currlife / sufferer.life;
        if (sufferer.currlife <= 0 && sufferer == this.T2) {
            var ani = sufferer.getComponent(cc.Animation);
            ani.playAdditive("T2Die");
        }
        if (this.FactionArrayOne[0].currlife <= 0 && this.FactionArrayOne[1].currlife <= 0 && this.FactionArrayOne[2].currlife <= 0) {
            this.winner.string = "Two Win!!";
            this.gameOver = 1;
        } else if (this.FactionArrayTwo[0].currlife <= 0 && this.FactionArrayTwo[1].currlife <= 0 && this.FactionArrayTwo[2].currlife <= 0) {
            this.winner.string = "One Win!!";
            this.gameOver = 1;
        }
    },

    button: function button() {
        var self = this;
        self.speedBt.node.on(cc.Node.EventType.TOUCH_END, function (event) {
            if (self.fightSpeed == 1) {
                self.btLabel.string = "X 2";
                self.fightSpeed = 2;
                self.animSpeed = 0.6;
                self.windSpeed = 0.6;
            } else if (self.fightSpeed == 2) {
                self.btLabel.string = "X 3";
                self.fightSpeed = 3;
                self.animSpeed = 0.8;
                self.windSpeed = 0.4;
            } else {
                self.btLabel.string = "X 1";
                self.fightSpeed = 1;
                self.animSpeed = 0.4;
                self.windSpeed = 0.8;
            }
        });
    },
    wind: function wind(releaser) {
        var wind = new cc.Node();
        var sprite = wind.addComponent(cc.Sprite);
        wind.parent = this.T1.parent;
        var array1 = this.getInfo(releaser);
        wind.x = array1[0] + 80;
        wind.y = array1[1];
        var windNum = 1; //wind第一张图
        //起风吧
        this.schedule(function () {
            var photo = cc.js.formatStr('resources/wind/winds%d.png', windNum);
            sprite.spriteFrame = new cc.SpriteFrame(cc.url.raw(photo));
            windNum++;
            if (windNum > 7) {
                windNum = 1;
            }
        }, 0.1, cc.REPEAT_FOREVER);
        return wind;
    },
    //技能：哈塞给
    HSG: function HSG(releaser) {
        var self = this;
        if (self.gameOver == 0) {
            (function () {
                releaser.NL.progress = 0;
                var sufferer = undefined;
                if (self.FactionArrayOne[self.Bsufferer].currlife > 0) {
                    sufferer = self.FactionArrayTwo[self.Bsufferer];
                } else {
                    self.Bsufferer++;
                    sufferer = self.FactionArrayTwo[self.Bsufferer];
                }
                var wind = self.wind(releaser);
                var moveX = sufferer.x - wind.x - sufferer.width / 2 - wind.width / 2;
                var moveY = sufferer.y - wind.y;
                var moveto = cc.moveBy(self.windSpeed, cc.p(moveX, moveY));
                var callBack = cc.callFunc(function () {
                    wind.destroy();
                    sufferer.currlife -= self.Kblood;
                    sufferer.ProgressBar.progress = sufferer.currlife / sufferer.life;
                    if (sufferer.currlife <= 0 && sufferer == self.T2) {
                        var ani = sufferer.getComponent(cc.Animation);
                        ani.playAdditive("T2Die");
                    }
                    if (self.FactionArrayOne[0].currlife <= 0 && self.FactionArrayOne[1].currlife <= 0 && self.FactionArrayOne[2].currlife <= 0) {
                        self.winner.string = "Two Win!!";
                        self.gameOver = 1;
                    } else if (self.FactionArrayTwo[0].currlife <= 0 && self.FactionArrayTwo[1].currlife <= 0 && self.FactionArrayTwo[2].currlife <= 0) {
                        self.winner.string = "One Win!!";
                        self.gameOver = 1;
                    }
                    self.fight();
                }, self);
                var delay = cc.delayTime(0.2);
                var callBac = cc.callFunc(function () {
                    var anima = releaser.getComponent(cc.Animation);
                    anima.playAdditive();
                }, self);
                wind.runAction(cc.sequence(callBac, delay, moveto, callBack));
            })();
        }
    },

    dazhao: function dazhao() {
        var self = this;
        self.T1NLButton.node.on(cc.Node.EventType.TOUCH_END, function (event) {
            if (self.T1.currlife > 0) {
                if (self.T1.NL.progress == 1) {
                    self.isT1FDZ = 1;
                    self.T1.NL.progress = 0;
                }
            }
        });
        self.adc1NLButton.node.on(cc.Node.EventType.TOUCH_END, function (event) {
            if (self.adc1.currlife > 0) {
                if (self.adc1.NL.progress == 1) {
                    self.isAdc1FDZ = 1;
                    self.adc1.NL.progress = 0;
                }
            }
        });
        self.ap1NLButton.node.on(cc.Node.EventType.TOUCH_END, function (event) {
            if (self.ap1.currlife > 0) {
                if (self.ap1.NL.progress == 1) {
                    self.isAp1FDZ = 1;
                    self.ap1.NL.progress = 0;
                }
            }
        });
    },
    autoButton: function autoButton() {
        if (this.isAuto == 0) {
            this.isAuto = 1;
            this.display.string = "自动";
        } else {
            this.isAuto = 0;
            this.display.string = "手动";
        }
    },
    init: function init() {
        //初始化血量
        this.T1.life = this.T1Life;
        this.T2.life = this.T2Life;
        this.adc1.life = this.adc1Life;
        this.adc2.life = this.adc2Life;
        this.ap1.life = this.ap1Life;
        this.ap2.life = this.ap2Life;
        //当前血量
        this.T1.currlife = this.T1Life;
        this.T2.currlife = this.T2Life;
        this.adc1.currlife = this.adc1Life;
        this.adc2.currlife = this.adc2Life;
        this.ap1.currlife = this.ap1Life;
        this.ap2.currlife = this.ap2Life;
        //肇事者
        this.Awrecker = 0;
        this.Bwrecker = 0;
        //受害人
        this.Asufferer = 0;
        this.Bsufferer = 0;
        //血条
        this.T1.ProgressBar = this.T1PB;
        this.T2.ProgressBar = this.T2PB;
        this.adc1.ProgressBar = this.adc1PB;
        this.adc2.ProgressBar = this.adc2PB;
        this.ap1.ProgressBar = this.ap1PB;
        this.ap2.ProgressBar = this.ap2PB;
        //能量
        this.T1.NL = this.T1NL;
        this.adc1.NL = this.adc1NL;
        this.ap1.NL = this.ap1NL;
        //其他参数
        this.ap1.scaleX = -1;
        this.missile.opacity = 0;
        this.fightSpeed = 1;
        this.fightAnimTime = 0.6;
        this.animSpeed = 0.3;
        this.btLabel.string = "X 1";
        this.isT1FDZ = 0;
        this.isAdc1FDZ = 0;
        this.isAp1FDZ = 0;
        this.isAuto = 0;
        this.windSpeed = 0.9;
        this.gameOver = 0;
    },
    onLoad: function onLoad() {
        this.init();
        //两个阵营内的角色
        this.FactionArrayOne = [this.T1, this.adc1, this.ap1];
        this.FactionArrayTwo = [this.T2, this.adc2, this.ap2];

        var ap2Anim = this.ap2.getComponent(cc.Animation);
        ap2Anim.playAdditive("ap2Animation");
        var ap1Anim = this.ap1.getComponent(cc.Animation);
        ap1Anim.playAdditive("ap1");
        this.schedule(function () {
            this.loadingLayout.destroy();
            this.fight();
        }, 2, 0);
        this.button();
        this.dazhao();
    },
    start: function start() {},
    update: function update(dt) {}
});

cc._RFpop();