#include "jsb_NetworkMSG.hpp"
#include "cocos2d_specifics.hpp"
#include "NetworkMSG.h"

template<class T>
static bool dummy_constructor(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS_ReportError(cx, "Constructor for the requested class is not available, please refer to the API reference.");
    return false;
}

static bool empty_constructor(JSContext *cx, uint32_t argc, jsval *vp) {
    return false;
}

static bool js_is_native_obj(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    args.rval().setBoolean(true);
    return true;    
}
JSClass  *jsb_NetworkMSG_class;
JSObject *jsb_NetworkMSG_prototype;

bool js_NetworkMSG_NetworkMSG_setConnectIP(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    NetworkMSG* cobj = (NetworkMSG *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_NetworkMSG_NetworkMSG_setConnectIP : Invalid Native Object");
    if (argc == 1) {
        const char* arg0 = nullptr;
        std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); arg0 = arg0_tmp.c_str();
        JSB_PRECONDITION2(ok, cx, false, "js_NetworkMSG_NetworkMSG_setConnectIP : Error processing arguments");
        cobj->setConnectIP(arg0);
        args.rval().setUndefined();
        return true;
    }

    JS_ReportError(cx, "js_NetworkMSG_NetworkMSG_setConnectIP : wrong number of arguments: %d, was expecting %d", argc, 1);
    return false;
}
bool js_NetworkMSG_NetworkMSG_sendData(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    NetworkMSG* cobj = (NetworkMSG *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_NetworkMSG_NetworkMSG_sendData : Invalid Native Object");
    if (argc == 2) {
        const char* arg0 = nullptr;
        unsigned short arg1 = 0;
        std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); arg0 = arg0_tmp.c_str();
        ok &= jsval_to_ushort(cx, args.get(1), &arg1);
        JSB_PRECONDITION2(ok, cx, false, "js_NetworkMSG_NetworkMSG_sendData : Error processing arguments");
        unsigned short ret = cobj->sendData(arg0, arg1);
        jsval jsret = JSVAL_NULL;
        jsret = ushort_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_NetworkMSG_NetworkMSG_sendData : wrong number of arguments: %d, was expecting %d", argc, 2);
    return false;
}
bool js_NetworkMSG_NetworkMSG_closeConnect(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    NetworkMSG* cobj = (NetworkMSG *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_NetworkMSG_NetworkMSG_closeConnect : Invalid Native Object");
    if (argc == 0) {
        cobj->closeConnect();
        args.rval().setUndefined();
        return true;
    }

    JS_ReportError(cx, "js_NetworkMSG_NetworkMSG_closeConnect : wrong number of arguments: %d, was expecting %d", argc, 0);
    return false;
}
bool js_NetworkMSG_NetworkMSG_setConnectDomain(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    NetworkMSG* cobj = (NetworkMSG *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_NetworkMSG_NetworkMSG_setConnectDomain : Invalid Native Object");
    if (argc == 1) {
        const char* arg0 = nullptr;
        std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); arg0 = arg0_tmp.c_str();
        JSB_PRECONDITION2(ok, cx, false, "js_NetworkMSG_NetworkMSG_setConnectDomain : Error processing arguments");
        cobj->setConnectDomain(arg0);
        args.rval().setUndefined();
        return true;
    }

    JS_ReportError(cx, "js_NetworkMSG_NetworkMSG_setConnectDomain : wrong number of arguments: %d, was expecting %d", argc, 1);
    return false;
}
bool js_NetworkMSG_NetworkMSG_getConnectPort(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    NetworkMSG* cobj = (NetworkMSG *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_NetworkMSG_NetworkMSG_getConnectPort : Invalid Native Object");
    if (argc == 0) {
        const int ret = cobj->getConnectPort();
        jsval jsret = JSVAL_NULL;
        jsret = int32_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_NetworkMSG_NetworkMSG_getConnectPort : wrong number of arguments: %d, was expecting %d", argc, 0);
    return false;
}
bool js_NetworkMSG_NetworkMSG_getConnectDomain(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    NetworkMSG* cobj = (NetworkMSG *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_NetworkMSG_NetworkMSG_getConnectDomain : Invalid Native Object");
    if (argc == 0) {
        const char* ret = cobj->getConnectDomain();
        jsval jsret = JSVAL_NULL;
        jsret = c_string_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_NetworkMSG_NetworkMSG_getConnectDomain : wrong number of arguments: %d, was expecting %d", argc, 0);
    return false;
}
bool js_NetworkMSG_NetworkMSG_connectFromDomain(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    NetworkMSG* cobj = (NetworkMSG *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_NetworkMSG_NetworkMSG_connectFromDomain : Invalid Native Object");
    if (argc == 2) {
        const char* arg0 = nullptr;
        int arg1 = 0;
        std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); arg0 = arg0_tmp.c_str();
        ok &= jsval_to_int32(cx, args.get(1), (int32_t *)&arg1);
        JSB_PRECONDITION2(ok, cx, false, "js_NetworkMSG_NetworkMSG_connectFromDomain : Error processing arguments");
        bool ret = cobj->connectFromDomain(arg0, arg1);
        jsval jsret = JSVAL_NULL;
        jsret = BOOLEAN_TO_JSVAL(ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_NetworkMSG_NetworkMSG_connectFromDomain : wrong number of arguments: %d, was expecting %d", argc, 2);
    return false;
}
bool js_NetworkMSG_NetworkMSG_setConnectPort(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    NetworkMSG* cobj = (NetworkMSG *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_NetworkMSG_NetworkMSG_setConnectPort : Invalid Native Object");
    if (argc == 1) {
        int arg0 = 0;
        ok &= jsval_to_int32(cx, args.get(0), (int32_t *)&arg0);
        JSB_PRECONDITION2(ok, cx, false, "js_NetworkMSG_NetworkMSG_setConnectPort : Error processing arguments");
        cobj->setConnectPort(arg0);
        args.rval().setUndefined();
        return true;
    }

    JS_ReportError(cx, "js_NetworkMSG_NetworkMSG_setConnectPort : wrong number of arguments: %d, was expecting %d", argc, 1);
    return false;
}
bool js_NetworkMSG_NetworkMSG_connectFromIP(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    NetworkMSG* cobj = (NetworkMSG *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_NetworkMSG_NetworkMSG_connectFromIP : Invalid Native Object");
    if (argc == 2) {
        const char* arg0 = nullptr;
        int arg1 = 0;
        std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); arg0 = arg0_tmp.c_str();
        ok &= jsval_to_int32(cx, args.get(1), (int32_t *)&arg1);
        JSB_PRECONDITION2(ok, cx, false, "js_NetworkMSG_NetworkMSG_connectFromIP : Error processing arguments");
        bool ret = cobj->connectFromIP(arg0, arg1);
        jsval jsret = JSVAL_NULL;
        jsret = BOOLEAN_TO_JSVAL(ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_NetworkMSG_NetworkMSG_connectFromIP : wrong number of arguments: %d, was expecting %d", argc, 2);
    return false;
}
bool js_NetworkMSG_NetworkMSG_getConnectIP(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    NetworkMSG* cobj = (NetworkMSG *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_NetworkMSG_NetworkMSG_getConnectIP : Invalid Native Object");
    if (argc == 0) {
        const char* ret = cobj->getConnectIP();
        jsval jsret = JSVAL_NULL;
        jsret = c_string_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_NetworkMSG_NetworkMSG_getConnectIP : wrong number of arguments: %d, was expecting %d", argc, 0);
    return false;
}
bool js_NetworkMSG_NetworkMSG_getInstance(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    if (argc == 0) {

        auto ret = NetworkMSG::getInstance();
        js_type_class_t *typeClass = js_get_type_from_native<NetworkMSG>(ret);
        JS::RootedObject jsret(cx, jsb_ref_get_or_create_jsobject(cx, ret, typeClass, "NetworkMSG"));
        args.rval().set(OBJECT_TO_JSVAL(jsret));
        return true;
    }
    JS_ReportError(cx, "js_NetworkMSG_NetworkMSG_getInstance : wrong number of arguments");
    return false;
}


extern JSObject *jsb_cocos2d_Ref_prototype;

void js_register_NetworkMSG_NetworkMSG(JSContext *cx, JS::HandleObject global) {
    jsb_NetworkMSG_class = (JSClass *)calloc(1, sizeof(JSClass));
    jsb_NetworkMSG_class->name = "NetworkMSG";
    jsb_NetworkMSG_class->addProperty = JS_PropertyStub;
    jsb_NetworkMSG_class->delProperty = JS_DeletePropertyStub;
    jsb_NetworkMSG_class->getProperty = JS_PropertyStub;
    jsb_NetworkMSG_class->setProperty = JS_StrictPropertyStub;
    jsb_NetworkMSG_class->enumerate = JS_EnumerateStub;
    jsb_NetworkMSG_class->resolve = JS_ResolveStub;
    jsb_NetworkMSG_class->convert = JS_ConvertStub;
    jsb_NetworkMSG_class->finalize = jsb_ref_finalize;
    jsb_NetworkMSG_class->flags = JSCLASS_HAS_RESERVED_SLOTS(2);

    static JSPropertySpec properties[] = {
        JS_PSG("__nativeObj", js_is_native_obj, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_PS_END
    };

    static JSFunctionSpec funcs[] = {
        JS_FN("setConnectIP", js_NetworkMSG_NetworkMSG_setConnectIP, 1, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("sendData", js_NetworkMSG_NetworkMSG_sendData, 2, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("closeConnect", js_NetworkMSG_NetworkMSG_closeConnect, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("setConnectDomain", js_NetworkMSG_NetworkMSG_setConnectDomain, 1, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("getConnectPort", js_NetworkMSG_NetworkMSG_getConnectPort, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("getConnectDomain", js_NetworkMSG_NetworkMSG_getConnectDomain, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("connectFromDomain", js_NetworkMSG_NetworkMSG_connectFromDomain, 2, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("setConnectPort", js_NetworkMSG_NetworkMSG_setConnectPort, 1, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("connectFromIP", js_NetworkMSG_NetworkMSG_connectFromIP, 2, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("getConnectIP", js_NetworkMSG_NetworkMSG_getConnectIP, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FS_END
    };

    static JSFunctionSpec st_funcs[] = {
        JS_FN("getInstance", js_NetworkMSG_NetworkMSG_getInstance, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FS_END
    };

    JS::RootedObject parent_proto(cx, jsb_cocos2d_Ref_prototype);
    jsb_NetworkMSG_prototype = JS_InitClass(
        cx, global,
        parent_proto,
        jsb_NetworkMSG_class,
        dummy_constructor<NetworkMSG>, 0, // no constructor
        properties,
        funcs,
        NULL, // no static properties
        st_funcs);

    // add the proto and JSClass to the type->js info hash table
    JS::RootedObject proto(cx, jsb_NetworkMSG_prototype);
    jsb_register_class<NetworkMSG>(cx, jsb_NetworkMSG_class, proto, parent_proto);
}

void register_all_NetworkMSG(JSContext* cx, JS::HandleObject obj) {
    // Get the global ns
    JS::RootedObject ns(cx, ScriptingCore::getInstance()->getGlobalObject());

    js_register_NetworkMSG_NetworkMSG(cx, ns);
}

