#include "jsb_odsocket.hpp"
#include "cocos2d_specifics.hpp"
#include "ODSocket.h"

template<class T>
static bool dummy_constructor(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS_ReportError(cx, "Constructor for the requested class is not available, please refer to the API reference.");
    return false;
}

static bool empty_constructor(JSContext *cx, uint32_t argc, jsval *vp) {
    return false;
}

static bool js_is_native_obj(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    args.rval().setBoolean(true);
    return true;    
}
JSClass  *jsb_ODSocket_class;
JSObject *jsb_ODSocket_prototype;

bool js_ODSocket_ODSocket_GetError(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    ODSocket* cobj = (ODSocket *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_ODSocket_ODSocket_GetError : Invalid Native Object");
    if (argc == 0) {
        int ret = cobj->GetError();
        jsval jsret = JSVAL_NULL;
        jsret = int32_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_ODSocket_ODSocket_GetError : wrong number of arguments: %d, was expecting %d", argc, 0);
    return false;
}
bool js_ODSocket_ODSocket_Bind(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    ODSocket* cobj = (ODSocket *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_ODSocket_ODSocket_Bind : Invalid Native Object");
    if (argc == 1) {
        unsigned short arg0 = 0;
        ok &= jsval_to_ushort(cx, args.get(0), &arg0);
        JSB_PRECONDITION2(ok, cx, false, "js_ODSocket_ODSocket_Bind : Error processing arguments");
        bool ret = cobj->Bind(arg0);
        jsval jsret = JSVAL_NULL;
        jsret = BOOLEAN_TO_JSVAL(ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_ODSocket_ODSocket_Bind : wrong number of arguments: %d, was expecting %d", argc, 1);
    return false;
}
bool js_ODSocket_ODSocket_Create(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    ODSocket* cobj = (ODSocket *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_ODSocket_ODSocket_Create : Invalid Native Object");
    if (argc == 2) {
        int arg0 = 0;
        int arg1 = 0;
        ok &= jsval_to_int32(cx, args.get(0), (int32_t *)&arg0);
        ok &= jsval_to_int32(cx, args.get(1), (int32_t *)&arg1);
        JSB_PRECONDITION2(ok, cx, false, "js_ODSocket_ODSocket_Create : Error processing arguments");
        bool ret = cobj->Create(arg0, arg1);
        jsval jsret = JSVAL_NULL;
        jsret = BOOLEAN_TO_JSVAL(ret);
        args.rval().set(jsret);
        return true;
    }
    if (argc == 3) {
        int arg0 = 0;
        int arg1 = 0;
        int arg2 = 0;
        ok &= jsval_to_int32(cx, args.get(0), (int32_t *)&arg0);
        ok &= jsval_to_int32(cx, args.get(1), (int32_t *)&arg1);
        ok &= jsval_to_int32(cx, args.get(2), (int32_t *)&arg2);
        JSB_PRECONDITION2(ok, cx, false, "js_ODSocket_ODSocket_Create : Error processing arguments");
        bool ret = cobj->Create(arg0, arg1, arg2);
        jsval jsret = JSVAL_NULL;
        jsret = BOOLEAN_TO_JSVAL(ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_ODSocket_ODSocket_Create : wrong number of arguments: %d, was expecting %d", argc, 2);
    return false;
}
bool js_ODSocket_ODSocket_Accept(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    ODSocket* cobj = (ODSocket *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_ODSocket_ODSocket_Accept : Invalid Native Object");
    if (argc == 1) {
        ODSocket* arg0;
        do {
            if (args.get(0).isNull()) { arg0 = nullptr; break; }
            if (!args.get(0).isObject()) { ok = false; break; }
            js_proxy_t *jsProxy;
            JS::RootedObject tmpObj(cx, args.get(0).toObjectOrNull());
            jsProxy = jsb_get_js_proxy(tmpObj);
            arg0 = (ODSocket*)(jsProxy ? jsProxy->ptr : NULL);
            JSB_PRECONDITION2( arg0, cx, false, "Invalid Native Object");
        } while (0);
        JSB_PRECONDITION2(ok, cx, false, "js_ODSocket_ODSocket_Accept : Error processing arguments");
        bool ret = cobj->Accept(*arg0);
        jsval jsret = JSVAL_NULL;
        jsret = BOOLEAN_TO_JSVAL(ret);
        args.rval().set(jsret);
        return true;
    }
    if (argc == 2) {
        ODSocket* arg0;
        char* arg1 = nullptr;
        do {
            if (args.get(0).isNull()) { arg0 = nullptr; break; }
            if (!args.get(0).isObject()) { ok = false; break; }
            js_proxy_t *jsProxy;
            JS::RootedObject tmpObj(cx, args.get(0).toObjectOrNull());
            jsProxy = jsb_get_js_proxy(tmpObj);
            arg0 = (ODSocket*)(jsProxy ? jsProxy->ptr : NULL);
            JSB_PRECONDITION2( arg0, cx, false, "Invalid Native Object");
        } while (0);
		std::string arg1_tmp; ok &= jsval_to_std_string(cx, args.get(1), &arg1_tmp); strcpy(arg1, arg1_tmp.c_str());
        JSB_PRECONDITION2(ok, cx, false, "js_ODSocket_ODSocket_Accept : Error processing arguments");
        bool ret = cobj->Accept(*arg0, arg1);
        jsval jsret = JSVAL_NULL;
        jsret = BOOLEAN_TO_JSVAL(ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_ODSocket_ODSocket_Accept : wrong number of arguments: %d, was expecting %d", argc, 1);
    return false;
}
bool js_ODSocket_ODSocket_Connect(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    ODSocket* cobj = (ODSocket *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_ODSocket_ODSocket_Connect : Invalid Native Object");
    if (argc == 2) {
        const char* arg0 = nullptr;
        unsigned short arg1 = 0;
        std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); arg0 = arg0_tmp.c_str();
        ok &= jsval_to_ushort(cx, args.get(1), &arg1);
        JSB_PRECONDITION2(ok, cx, false, "js_ODSocket_ODSocket_Connect : Error processing arguments");
        bool ret = cobj->Connect(arg0, arg1);
        jsval jsret = JSVAL_NULL;
        jsret = BOOLEAN_TO_JSVAL(ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_ODSocket_ODSocket_Connect : wrong number of arguments: %d, was expecting %d", argc, 2);
    return false;
}
bool js_ODSocket_ODSocket_Send(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    ODSocket* cobj = (ODSocket *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_ODSocket_ODSocket_Send : Invalid Native Object");
    if (argc == 2) {
        const char* arg0 = nullptr;
        int arg1 = 0;
        std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); arg0 = arg0_tmp.c_str();
        ok &= jsval_to_int32(cx, args.get(1), (int32_t *)&arg1);
        JSB_PRECONDITION2(ok, cx, false, "js_ODSocket_ODSocket_Send : Error processing arguments");
        int ret = cobj->Send(arg0, arg1);
        jsval jsret = JSVAL_NULL;
        jsret = int32_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }
    if (argc == 3) {
        const char* arg0 = nullptr;
        int arg1 = 0;
        int arg2 = 0;
        std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); arg0 = arg0_tmp.c_str();
        ok &= jsval_to_int32(cx, args.get(1), (int32_t *)&arg1);
        ok &= jsval_to_int32(cx, args.get(2), (int32_t *)&arg2);
        JSB_PRECONDITION2(ok, cx, false, "js_ODSocket_ODSocket_Send : Error processing arguments");
        int ret = cobj->Send(arg0, arg1, arg2);
        jsval jsret = JSVAL_NULL;
        jsret = int32_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_ODSocket_ODSocket_Send : wrong number of arguments: %d, was expecting %d", argc, 2);
    return false;
}
bool js_ODSocket_ODSocket_Close(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    ODSocket* cobj = (ODSocket *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_ODSocket_ODSocket_Close : Invalid Native Object");
    if (argc == 0) {
        int ret = cobj->Close();
        jsval jsret = JSVAL_NULL;
        jsret = int32_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_ODSocket_ODSocket_Close : wrong number of arguments: %d, was expecting %d", argc, 0);
    return false;
}
bool js_ODSocket_ODSocket_Recv(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    ODSocket* cobj = (ODSocket *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_ODSocket_ODSocket_Recv : Invalid Native Object");
    if (argc == 2) {
        char* arg0 = nullptr;
        int arg1 = 0;
		std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); strcpy(arg0, arg0_tmp.c_str());
        ok &= jsval_to_int32(cx, args.get(1), (int32_t *)&arg1);
        JSB_PRECONDITION2(ok, cx, false, "js_ODSocket_ODSocket_Recv : Error processing arguments");
        int ret = cobj->Recv(arg0, arg1);
        jsval jsret = JSVAL_NULL;
        jsret = int32_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }
    if (argc == 3) {
        char* arg0 = nullptr;
        int arg1 = 0;
        int arg2 = 0;
		std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); strcpy(arg0, arg0_tmp.c_str());
        ok &= jsval_to_int32(cx, args.get(1), (int32_t *)&arg1);
        ok &= jsval_to_int32(cx, args.get(2), (int32_t *)&arg2);
        JSB_PRECONDITION2(ok, cx, false, "js_ODSocket_ODSocket_Recv : Error processing arguments");
        int ret = cobj->Recv(arg0, arg1, arg2);
        jsval jsret = JSVAL_NULL;
        jsret = int32_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_ODSocket_ODSocket_Recv : wrong number of arguments: %d, was expecting %d", argc, 2);
    return false;
}
bool js_ODSocket_ODSocket_Listen(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    ODSocket* cobj = (ODSocket *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_ODSocket_ODSocket_Listen : Invalid Native Object");
    if (argc == 0) {
        bool ret = cobj->Listen();
        jsval jsret = JSVAL_NULL;
        jsret = BOOLEAN_TO_JSVAL(ret);
        args.rval().set(jsret);
        return true;
    }
    if (argc == 1) {
        int arg0 = 0;
        ok &= jsval_to_int32(cx, args.get(0), (int32_t *)&arg0);
        JSB_PRECONDITION2(ok, cx, false, "js_ODSocket_ODSocket_Listen : Error processing arguments");
        bool ret = cobj->Listen(arg0);
        jsval jsret = JSVAL_NULL;
        jsret = BOOLEAN_TO_JSVAL(ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_ODSocket_ODSocket_Listen : wrong number of arguments: %d, was expecting %d", argc, 0);
    return false;
}
bool js_ODSocket_ODSocket_Init(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    if (argc == 0) {

        int ret = ODSocket::Init();
        jsval jsret = JSVAL_NULL;
        jsret = int32_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }
    JS_ReportError(cx, "js_ODSocket_ODSocket_Init : wrong number of arguments");
    return false;
}

bool js_ODSocket_ODSocket_DnsParse(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    if (argc == 2) {
        const char* arg0 = nullptr;
        char* arg1 = nullptr;
        std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); arg0 = arg0_tmp.c_str();
		std::string arg1_tmp; ok &= jsval_to_std_string(cx, args.get(1), &arg1_tmp); strcpy(arg1, arg1_tmp.c_str());
        JSB_PRECONDITION2(ok, cx, false, "js_ODSocket_ODSocket_DnsParse : Error processing arguments");

        bool ret = ODSocket::DnsParse(arg0, arg1);
        jsval jsret = JSVAL_NULL;
        jsret = BOOLEAN_TO_JSVAL(ret);
        args.rval().set(jsret);
        return true;
    }
    JS_ReportError(cx, "js_ODSocket_ODSocket_DnsParse : wrong number of arguments");
    return false;
}

bool js_ODSocket_ODSocket_Clean(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    if (argc == 0) {

        int ret = ODSocket::Clean();
        jsval jsret = JSVAL_NULL;
        jsret = int32_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }
    JS_ReportError(cx, "js_ODSocket_ODSocket_Clean : wrong number of arguments");
    return false;
}

bool js_ODSocket_ODSocket_constructor(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    ODSocket* cobj = new (std::nothrow) ODSocket();

    js_type_class_t *typeClass = js_get_type_from_native<ODSocket>(cobj);

    // link the native object with the javascript object
    JS::RootedObject proto(cx, typeClass->proto.ref());
    JS::RootedObject parent(cx, typeClass->parentProto.ref());
    JS::RootedObject jsobj(cx, JS_NewObject(cx, typeClass->jsclass, proto, parent));
    js_proxy_t* p = jsb_new_proxy(cobj, jsobj);
    AddNamedObjectRoot(cx, &p->obj, "ODSocket");
    args.rval().set(OBJECT_TO_JSVAL(jsobj));
    if (JS_HasProperty(cx, jsobj, "_ctor", &ok) && ok)
        ScriptingCore::getInstance()->executeFunctionWithOwner(OBJECT_TO_JSVAL(jsobj), "_ctor", args);
    return true;
}


void js_ODSocket_finalize(JSFreeOp *fop, JSObject *obj) {
    CCLOGINFO("jsbindings: finalizing JS object %p (ODSocket)", obj);
    js_proxy_t* nproxy;
    js_proxy_t* jsproxy;
    JSContext *cx = ScriptingCore::getInstance()->getGlobalContext();
    JS::RootedObject jsobj(cx, obj);
    jsproxy = jsb_get_js_proxy(jsobj);
    if (jsproxy) {
        ODSocket *nobj = static_cast<ODSocket *>(jsproxy->ptr);
        nproxy = jsb_get_native_proxy(jsproxy->ptr);

        if (nobj) {
            jsb_remove_proxy(nproxy, jsproxy);
            delete nobj;
        }
        else
            jsb_remove_proxy(nullptr, jsproxy);
    }
}
void js_register_ODSocket_ODSocket(JSContext *cx, JS::HandleObject global) {
    jsb_ODSocket_class = (JSClass *)calloc(1, sizeof(JSClass));
    jsb_ODSocket_class->name = "ODSocket";
    jsb_ODSocket_class->addProperty = JS_PropertyStub;
    jsb_ODSocket_class->delProperty = JS_DeletePropertyStub;
    jsb_ODSocket_class->getProperty = JS_PropertyStub;
    jsb_ODSocket_class->setProperty = JS_StrictPropertyStub;
    jsb_ODSocket_class->enumerate = JS_EnumerateStub;
    jsb_ODSocket_class->resolve = JS_ResolveStub;
    jsb_ODSocket_class->convert = JS_ConvertStub;
    jsb_ODSocket_class->finalize = js_ODSocket_finalize;
    jsb_ODSocket_class->flags = JSCLASS_HAS_RESERVED_SLOTS(2);

    static JSPropertySpec properties[] = {
        JS_PSG("__nativeObj", js_is_native_obj, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_PS_END
    };

    static JSFunctionSpec funcs[] = {
        JS_FN("GetError", js_ODSocket_ODSocket_GetError, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("Bind", js_ODSocket_ODSocket_Bind, 1, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("Create", js_ODSocket_ODSocket_Create, 2, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("Accept", js_ODSocket_ODSocket_Accept, 1, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("Connect", js_ODSocket_ODSocket_Connect, 2, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("Send", js_ODSocket_ODSocket_Send, 2, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("Close", js_ODSocket_ODSocket_Close, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("Recv", js_ODSocket_ODSocket_Recv, 2, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("Listen", js_ODSocket_ODSocket_Listen, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FS_END
    };

    static JSFunctionSpec st_funcs[] = {
        JS_FN("Init", js_ODSocket_ODSocket_Init, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("DnsParse", js_ODSocket_ODSocket_DnsParse, 2, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("Clean", js_ODSocket_ODSocket_Clean, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FS_END
    };

    jsb_ODSocket_prototype = JS_InitClass(
        cx, global,
        JS::NullPtr(),
        jsb_ODSocket_class,
        js_ODSocket_ODSocket_constructor, 0, // constructor
        properties,
        funcs,
        NULL, // no static properties
        st_funcs);

    // add the proto and JSClass to the type->js info hash table
    JS::RootedObject proto(cx, jsb_ODSocket_prototype);
    jsb_register_class<ODSocket>(cx, jsb_ODSocket_class, proto, JS::NullPtr());
}

void register_all_ODSocket(JSContext* cx, JS::HandleObject obj) {
    // Get the global ns
    JS::RootedObject ns(cx, ScriptingCore::getInstance()->getGlobalObject());

    js_register_ODSocket_ODSocket(cx, ns);
}

