#include "MTNotificationQueue.h"
USING_NS_CC;

//ȫΨһ
pthread_mutex_t sharedNotificationQueueLock;

/* 		ǵкĳʼ
		һȫֱ			*/
class LifeManager_PThreadMutex
{
	pthread_mutex_t* mutex;

public:
	LifeManager_PThreadMutex(pthread_mutex_t* mut) : mutex(mut)
	{
		pthread_mutex_init(mutex, NULL);
	}

	~LifeManager_PThreadMutex()
	{
		pthread_mutex_destroy(mutex);
	}
}__LifeManager_sharedNotificationQueueLock(&sharedNotificationQueueLock);


/*	ͬǵӦһκһ
	εĿʼͽԶӦһʱ
	Уٴηװһ	*/
class LifeCircleMutexLocker
{
	pthread_mutex_t* mutex;

public:
	LifeCircleMutexLocker(pthread_mutex_t* aMutex) : mutex(aMutex)
	{
		pthread_mutex_lock(mutex);
	}
	~LifeCircleMutexLocker(){
		pthread_mutex_unlock(mutex);
	}
};

#define LifeCircleMutexLock(mutex) LifeCircleMutexLocker __locker__(mutex) 



//ʼΨһʵ
MTNotificationQueue* MTNotificationQueue::mInstance = NULL;

//캯
MTNotificationQueue::MTNotificationQueue(void)
{
}

//
MTNotificationQueue::~MTNotificationQueue(void)
{
}

//Ψһʵ
MTNotificationQueue* MTNotificationQueue::getInstance()
{
	if (!mInstance)
	{
		mInstance = new MTNotificationQueue();
	}

	return mInstance;
}

//ϢнϢCocos2dxϢ
void MTNotificationQueue::postNotifications(float dt)
{
	LifeCircleMutexLock(&sharedNotificationQueueLock);

	for (int i = 0; i < notifications.size(); i++)
	{
		NotificationArgs &arg = notifications[i];
		_eventDispatcher->dispatchCustomEvent(arg.name.c_str(), arg.sender);
		log(">>>>>>>>name = %s", arg.name.c_str());
	}
}

//ϢзϢ
void MTNotificationQueue::postNotification(const char* name, Ref* sender)
{
	LifeCircleMutexLock(&sharedNotificationQueueLock);

	NotificationArgs arg;
	arg.name = name;

	if (sender != NULL)
		arg.sender = sender;
	else
		arg.sender = NULL;

	notifications.push_back(arg);
}

std::string MTNotificationQueue::getMessageByName(std::string name)
{
	//LifeCircleMutexLock(&sharedNotificationQueueLock);

	for (int i = 0; i < notifications.size(); i++)
	{
		if (notifications[i].name == name && notifications[i].sender)
		{
			Message* msg = (Message*)notifications[i].sender;
			std::string msgcontent = ((Message*)notifications[i].sender)->getMSGByChar();
			notifications.erase(notifications.begin() + i);
			log("message ref count is %d", msg->getReferenceCount());
			msg->release();
			log("----message ref count is %d----", msg->getReferenceCount());
			return msgcontent;
		}
	}
	return nullptr;
}

