#include "NetworkMSG.h"

USING_NS_CC;

NetworkMSG* NetworkMSG::m_Instance = new NetworkMSG;

NetworkMSG::NetworkMSG()
{
	memset(serverIP, 0, sizeof(serverIP));
	serverPort = 0;
	receiveThread = false;
	connectState = false;
}


bool NetworkMSG::connectFromIP(const char* ip, int port)
{
	if (!connectState)
	{
		log("connectIP");
		//ʼsocket
		socket.Init();
		//socket
		socket.Create(AF_INET, SOCK_STREAM, 0);
		memcpy(serverIP, ip, strlen(ip));
		serverPort = port;
		if (socket.Connect(serverIP, serverPort))
		{
			log("connect succeed");
			connectState = true;
			return true;
		}
		log("connect faild");
		return false;
	}
	else return true;
}

bool NetworkMSG::connectFromDomain(const char* domain, int port)
{
	if (!connectState)
	{
		log("connectDomain");
		//ʼsocket
		socket.Init();
		//socket
		socket.Create(AF_INET, SOCK_STREAM, 0);
		if (socket.DnsParse(domain, serverIP))
		{
			memcpy(serverDomain, domain, strlen(domain));
			serverPort = port;
			if (socket.Connect(serverIP, serverPort))
			{
				connectState = true;
				log("connect succeed");
				return true;
			}
		}
		log("connect faild");
		return false;
	}
	else return true;
}


unsigned short NetworkMSG::sendData(const char* msg, unsigned short size)
{
	log("sendData");

	if (receiveThread&&connectState)
	{
		unsigned short amount = socket.Send(msg, size, 0);
		log("repeat send");
		return amount;
	}
	else
	{
		if (connectState)
		{
			log("first send");
			unsigned short amount = socket.Send(msg, size, 0);

			// ̣߳߳У
			std::thread recvThread = std::thread(&NetworkMSG::receiveData, this);
			// ̷߳
			recvThread.detach();

			return amount;
		}
		else
		{
			if (connectFromIP(serverIP, serverPort))
			{
				unsigned short amount = socket.Send(msg, size, 0);

				// ̣߳߳У
				std::thread recvThread = std::thread(&NetworkMSG::receiveData, this);
				// ̷߳
				recvThread.detach();

				return amount;
			}
		}

	}

	return -1;
}

void NetworkMSG::receiveData()
{
	log("receiveData");

	receiveThread = true;
	while (true)
	{
		char data[65535] = { 0 };
		char da[100] = { 0 };
		int recv = socket.Recv(data, 65535, 0);
		log("recv=%d", recv);
		for (int j = 14; j < recv; j++)
		{
			da[j - 14] = data[j];
		}
		log("message=%s", da);
		if (recv == -1)
		{
			log("continue");
			continue;
		}
		else if (recv>0)
		{
			Message* str = Message::create(da, strlen(da));
			str->retain();
			//log("data=%s",data);
			//Packet a;
			//a = (Packet&)data;
			//log("buffSIZE=%d", a.Packet_Size);
			//log("buffID=%d", a.Packet_Id);
			//log("buffMSG=%d", a.Packet_Msg);
			//log("buffRECODE=%d", a.Packet_Recode);
			//log("buffData=%s", a.d.Buffer_Data);
			MTNotificationQueue::getInstance()->postNotification("finish", str);
		}
		else
		{
			log("Break");
			break;
		}
	}
	log("socket.close");
	receiveThread = false;
	connectState = false;
	socket.Close();
	MTNotificationQueue::getInstance()->postNotification("disconnect", NULL);
	return;
}

const char* NetworkMSG::getConnectIP()
{
	return serverIP;
}
void NetworkMSG::setConnectIP(const char* newip)
{
	memcpy(serverIP, newip, strlen(newip));
}

const char* NetworkMSG::getConnectDomain()
{
	return serverDomain;
}

void NetworkMSG::setConnectDomain(const char* newdomain)
{
	memcpy(serverDomain, newdomain, strlen(newdomain));
}

const int NetworkMSG::getConnectPort()
{
	return serverPort;
}

void NetworkMSG::setConnectPort(int newport)
{
	serverPort = newport;
}

void NetworkMSG::closeConnect()
{
	if (connectState)
	{
		socket.Close();
		connectState = false;
		receiveThread = false;
	}
}