#ifndef __NETWORK_MSG_H__
#define __NETWORK_MSG_H__
#include "cocos2d.h"
#include "ODSocket.h"
#include "MTNotificationQueue.h"
#include "Message.h"

class NetworkMSG:public cocos2d::Ref
{
private:
	static NetworkMSG* m_Instance;
	NetworkMSG();
	void receiveData();

	//׽
	ODSocket socket;
	char serverIP[20];
	char serverDomain[50];
	int serverPort;
	bool receiveThread;
	bool connectState;
	 
public:
	~NetworkMSG(){};
	static NetworkMSG* getInstance()
	{
		return m_Instance;
	}
	bool connectFromIP(const char* ip, int port);
	bool connectFromDomain(const char* domain, int port);
	unsigned short sendData(const char* msg, unsigned short size);

	const char* getConnectIP();
	void setConnectIP(const char* newip);

	const char* getConnectDomain();
	void setConnectDomain(const char* newdomain);

	const int getConnectPort();
	void setConnectPort(int newport);

	void closeConnect();

};


#endif //__NETWORK_MSG_H__