#include "jsb_MTNotificationQueue.hpp"
#include "cocos2d_specifics.hpp"
#include "MTNotificationQueue.h"

template<class T>
static bool dummy_constructor(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS_ReportError(cx, "Constructor for the requested class is not available, please refer to the API reference.");
    return false;
}

static bool empty_constructor(JSContext *cx, uint32_t argc, jsval *vp) {
    return false;
}

static bool js_is_native_obj(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    args.rval().setBoolean(true);
    return true;    
}
JSClass  *jsb_MTNotificationQueue_class;
JSObject *jsb_MTNotificationQueue_prototype;

bool js_MTNotificationQueue_MTNotificationQueue_postNotifications(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    MTNotificationQueue* cobj = (MTNotificationQueue *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_MTNotificationQueue_MTNotificationQueue_postNotifications : Invalid Native Object");
    if (argc == 1) {
        double arg0 = 0;
        ok &= JS::ToNumber( cx, args.get(0), &arg0) && !isnan(arg0);
        JSB_PRECONDITION2(ok, cx, false, "js_MTNotificationQueue_MTNotificationQueue_postNotifications : Error processing arguments");
        cobj->postNotifications(arg0);
        args.rval().setUndefined();
        return true;
    }

    JS_ReportError(cx, "js_MTNotificationQueue_MTNotificationQueue_postNotifications : wrong number of arguments: %d, was expecting %d", argc, 1);
    return false;
}
bool js_MTNotificationQueue_MTNotificationQueue_postNotification(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    MTNotificationQueue* cobj = (MTNotificationQueue *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_MTNotificationQueue_MTNotificationQueue_postNotification : Invalid Native Object");
    if (argc == 2) {
        const char* arg0 = nullptr;
        cocos2d::Ref* arg1 = nullptr;
        std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); arg0 = arg0_tmp.c_str();
        do {
            if (args.get(1).isNull()) { arg1 = nullptr; break; }
            if (!args.get(1).isObject()) { ok = false; break; }
            js_proxy_t *jsProxy;
            JS::RootedObject tmpObj(cx, args.get(1).toObjectOrNull());
            jsProxy = jsb_get_js_proxy(tmpObj);
            arg1 = (cocos2d::Ref*)(jsProxy ? jsProxy->ptr : NULL);
            JSB_PRECONDITION2( arg1, cx, false, "Invalid Native Object");
        } while (0);
        JSB_PRECONDITION2(ok, cx, false, "js_MTNotificationQueue_MTNotificationQueue_postNotification : Error processing arguments");
        cobj->postNotification(arg0, arg1);
        args.rval().setUndefined();
        return true;
    }

    JS_ReportError(cx, "js_MTNotificationQueue_MTNotificationQueue_postNotification : wrong number of arguments: %d, was expecting %d", argc, 2);
    return false;
}
bool js_MTNotificationQueue_MTNotificationQueue_getMessageByName(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    MTNotificationQueue* cobj = (MTNotificationQueue *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_MTNotificationQueue_MTNotificationQueue_getMessageByName : Invalid Native Object");
    if (argc == 1) {
        std::string arg0;
        ok &= jsval_to_std_string(cx, args.get(0), &arg0);
        JSB_PRECONDITION2(ok, cx, false, "js_MTNotificationQueue_MTNotificationQueue_getMessageByName : Error processing arguments");
        std::string ret = cobj->getMessageByName(arg0);
        jsval jsret = JSVAL_NULL;
        jsret = std_string_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_MTNotificationQueue_MTNotificationQueue_getMessageByName : wrong number of arguments: %d, was expecting %d", argc, 1);
    return false;
}
bool js_MTNotificationQueue_MTNotificationQueue_getInstance(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    if (argc == 0) {

        auto ret = MTNotificationQueue::getInstance();
        js_type_class_t *typeClass = js_get_type_from_native<MTNotificationQueue>(ret);
        JS::RootedObject jsret(cx, jsb_ref_get_or_create_jsobject(cx, ret, typeClass, "MTNotificationQueue"));
        args.rval().set(OBJECT_TO_JSVAL(jsret));
        return true;
    }
    JS_ReportError(cx, "js_MTNotificationQueue_MTNotificationQueue_getInstance : wrong number of arguments");
    return false;
}


extern JSObject *jsb_cocos2d_Node_prototype;

void js_register_MTNotificationQueue_MTNotificationQueue(JSContext *cx, JS::HandleObject global) {
    jsb_MTNotificationQueue_class = (JSClass *)calloc(1, sizeof(JSClass));
    jsb_MTNotificationQueue_class->name = "MTNotificationQueue";
    jsb_MTNotificationQueue_class->addProperty = JS_PropertyStub;
    jsb_MTNotificationQueue_class->delProperty = JS_DeletePropertyStub;
    jsb_MTNotificationQueue_class->getProperty = JS_PropertyStub;
    jsb_MTNotificationQueue_class->setProperty = JS_StrictPropertyStub;
    jsb_MTNotificationQueue_class->enumerate = JS_EnumerateStub;
    jsb_MTNotificationQueue_class->resolve = JS_ResolveStub;
    jsb_MTNotificationQueue_class->convert = JS_ConvertStub;
    jsb_MTNotificationQueue_class->finalize = jsb_ref_finalize;
    jsb_MTNotificationQueue_class->flags = JSCLASS_HAS_RESERVED_SLOTS(2);

    static JSPropertySpec properties[] = {
        JS_PSG("__nativeObj", js_is_native_obj, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_PS_END
    };

    static JSFunctionSpec funcs[] = {
        JS_FN("postNotifications", js_MTNotificationQueue_MTNotificationQueue_postNotifications, 1, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("postNotification", js_MTNotificationQueue_MTNotificationQueue_postNotification, 2, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("getMessageByName", js_MTNotificationQueue_MTNotificationQueue_getMessageByName, 1, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FS_END
    };

    static JSFunctionSpec st_funcs[] = {
        JS_FN("getInstance", js_MTNotificationQueue_MTNotificationQueue_getInstance, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FS_END
    };

    JS::RootedObject parent_proto(cx, jsb_cocos2d_Node_prototype);
    jsb_MTNotificationQueue_prototype = JS_InitClass(
        cx, global,
        parent_proto,
        jsb_MTNotificationQueue_class,
        dummy_constructor<MTNotificationQueue>, 0, // no constructor
        properties,
        funcs,
        NULL, // no static properties
        st_funcs);

    // add the proto and JSClass to the type->js info hash table
    JS::RootedObject proto(cx, jsb_MTNotificationQueue_prototype);
    jsb_register_class<MTNotificationQueue>(cx, jsb_MTNotificationQueue_class, proto, parent_proto);
}

void register_all_MTNotificationQueue(JSContext* cx, JS::HandleObject obj) {
    // Get the global ns
    JS::RootedObject ns(cx, ScriptingCore::getInstance()->getGlobalObject());

    js_register_MTNotificationQueue_MTNotificationQueue(cx, ns);
}

