#include "jsb_Message.hpp"
#include "cocos2d_specifics.hpp"
#include "Message.h"

template<class T>
static bool dummy_constructor(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS_ReportError(cx, "Constructor for the requested class is not available, please refer to the API reference.");
    return false;
}

static bool empty_constructor(JSContext *cx, uint32_t argc, jsval *vp) {
    return false;
}

static bool js_is_native_obj(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    args.rval().setBoolean(true);
    return true;    
}
JSClass  *jsb_Message_class;
JSObject *jsb_Message_prototype;

bool js_Message_Message_init(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    Message* cobj = (Message *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_Message_Message_init : Invalid Native Object");
    if (argc == 2) {
        const char* arg0 = nullptr;
        unsigned short arg1 = 0;
        std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); arg0 = arg0_tmp.c_str();
        ok &= jsval_to_ushort(cx, args.get(1), &arg1);
        JSB_PRECONDITION2(ok, cx, false, "js_Message_Message_init : Error processing arguments");
        bool ret = cobj->init(arg0, arg1);
        jsval jsret = JSVAL_NULL;
        jsret = BOOLEAN_TO_JSVAL(ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_Message_Message_init : wrong number of arguments: %d, was expecting %d", argc, 2);
    return false;
}
bool js_Message_Message_getMSGByChar(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    JS::RootedObject obj(cx, args.thisv().toObjectOrNull());
    js_proxy_t *proxy = jsb_get_js_proxy(obj);
    Message* cobj = (Message *)(proxy ? proxy->ptr : NULL);
    JSB_PRECONDITION2( cobj, cx, false, "js_Message_Message_getMSGByChar : Invalid Native Object");
    if (argc == 0) {
        char* ret = cobj->getMSGByChar();
        jsval jsret = JSVAL_NULL;
        jsret = c_string_to_jsval(cx, ret);
        args.rval().set(jsret);
        return true;
    }

    JS_ReportError(cx, "js_Message_Message_getMSGByChar : wrong number of arguments: %d, was expecting %d", argc, 0);
    return false;
}
bool js_Message_Message_create(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    if (argc == 2) {
        const char* arg0 = nullptr;
        unsigned short arg1 = 0;
        std::string arg0_tmp; ok &= jsval_to_std_string(cx, args.get(0), &arg0_tmp); arg0 = arg0_tmp.c_str();
        ok &= jsval_to_ushort(cx, args.get(1), &arg1);
        JSB_PRECONDITION2(ok, cx, false, "js_Message_Message_create : Error processing arguments");

        auto ret = Message::create(arg0, arg1);
        js_type_class_t *typeClass = js_get_type_from_native<Message>(ret);
        JS::RootedObject jsret(cx, jsb_ref_autoreleased_create_jsobject(cx, ret, typeClass, "Message"));
        args.rval().set(OBJECT_TO_JSVAL(jsret));
        return true;
    }
    JS_ReportError(cx, "js_Message_Message_create : wrong number of arguments");
    return false;
}

bool js_Message_Message_constructor(JSContext *cx, uint32_t argc, jsval *vp)
{
    JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
    bool ok = true;
    Message* cobj = new (std::nothrow) Message();

    js_type_class_t *typeClass = js_get_type_from_native<Message>(cobj);

    // link the native object with the javascript object
    JS::RootedObject jsobj(cx, jsb_ref_create_jsobject(cx, cobj, typeClass, "Message"));
    args.rval().set(OBJECT_TO_JSVAL(jsobj));
    if (JS_HasProperty(cx, jsobj, "_ctor", &ok) && ok)
        ScriptingCore::getInstance()->executeFunctionWithOwner(OBJECT_TO_JSVAL(jsobj), "_ctor", args);
    return true;
}


extern JSObject *jsb_cocos2d_Ref_prototype = NULL;

void js_register_Message_Message(JSContext *cx, JS::HandleObject global) {
    jsb_Message_class = (JSClass *)calloc(1, sizeof(JSClass));
    jsb_Message_class->name = "Message";
    jsb_Message_class->addProperty = JS_PropertyStub;
    jsb_Message_class->delProperty = JS_DeletePropertyStub;
    jsb_Message_class->getProperty = JS_PropertyStub;
    jsb_Message_class->setProperty = JS_StrictPropertyStub;
    jsb_Message_class->enumerate = JS_EnumerateStub;
    jsb_Message_class->resolve = JS_ResolveStub;
    jsb_Message_class->convert = JS_ConvertStub;
    jsb_Message_class->finalize = jsb_ref_finalize;
    jsb_Message_class->flags = JSCLASS_HAS_RESERVED_SLOTS(2);

    static JSPropertySpec properties[] = {
        JS_PSG("__nativeObj", js_is_native_obj, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_PS_END
    };

    static JSFunctionSpec funcs[] = {
        JS_FN("init", js_Message_Message_init, 2, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FN("getMSGByChar", js_Message_Message_getMSGByChar, 0, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FS_END
    };

    static JSFunctionSpec st_funcs[] = {
        JS_FN("create", js_Message_Message_create, 2, JSPROP_PERMANENT | JSPROP_ENUMERATE),
        JS_FS_END
    };

    JS::RootedObject parent_proto(cx, jsb_cocos2d_Ref_prototype);
    jsb_Message_prototype = JS_InitClass(
        cx, global,
        parent_proto,
        jsb_Message_class,
        js_Message_Message_constructor, 0, // constructor
        properties,
        funcs,
        NULL, // no static properties
        st_funcs);

    // add the proto and JSClass to the type->js info hash table
    JS::RootedObject proto(cx, jsb_Message_prototype);
    jsb_register_class<Message>(cx, jsb_Message_class, proto, parent_proto);
}

void register_all_Message(JSContext* cx, JS::HandleObject obj) {
    // Get the global ns
    JS::RootedObject ns(cx, ScriptingCore::getInstance()->getGlobalObject());

    js_register_Message_Message(cx, ns);
}

