cc.Class({
    'extends': cc.Component,

    properties: {
        bulletfab: {
            'default': null,
            type: cc.Prefab
        }
    },

    onLoad: function onLoad() {
        this._attackTimer = 0.0;
        this.interval = 1;
        this._bs = require('EnemyBullet');
    },

    //create bullet
    createBullet: function createBullet() {
        var bullet = null;
        if (cc.pool.hasObject(this._bs)) {
            bullet = cc.pool.getFromPool(this._bs);
            cc.log("create from Pool!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        } else {
            bullet = cc.instantiate(this.bulletfab).getComponent('EnemyBullet');
        }
        var canvas = cc.director.getScene().getChildByName('Canvas');
        bullet.node.setParent(canvas);
        var box = this.node.getBoundingBoxToWorld();
        bullet.node.setPosition(cc.p(box.x + box.width / 2 - canvas.getPositionX(), box.y - canvas.getPositionY()));
        bullet.node.addComponent(require('MoveAction'));
        //bullet.init(this.bulletMoveMode);
    },

    // called every frame, uncomment this function to activate update callback
    update: function update(dt) {

        this._attackTimer += dt;
        if (this._attackTimer >= 0.5) {
            this._attackTimer = 0;
            this.createBullet();
        }
    }
});