cc.Class({
    'extends': cc.Component,

    properties: {
        move: 'MoveAction'
    },

    // use this for initialization
    onLoad: function onLoad() {},

    // init: function (move) {
    //     this.move = 'MoveAction';
    // },

    inScreen: function inScreen() {
        return cc.Rect.fromMinMax(cc.visibleRect.bottomLeft, cc.visibleRect.topRight).intersects(this.node.getBoundingBoxToWorld());
    },

    recycle: function recycle() {
        this.node.getComponent('MoveAction').stopMoveAction();
        cc.pool.putInPool(this);
    },
    onHit: function onHit() {
        this._recycle = true;
    },
    // called every frame, uncomment this function to activate update callback
    update: function update(dt) {
        // recycle on clock cycle
        if (this._recycle) {
            this._recycle = false;
            this.recycle();
            return;
        }
        if (!this.inScreen()) {
            //recycle
            this._recycle = true;
        }
    },

    unuse: function unuse() {
        //this.node.getComponent('MoveAction').stopMoveAction();
        this.node.removeComponent('MoveAction');
        this.node.removeFromParent();
    },

    reuse: function reuse() {}
});