const { ccclass, property } = cc._decorator;

@ccclass
export default class allSeeCam extends cc.Component {

    @property(cc.Camera)
    allSeeCam: cc.Camera = null;
    @property(cc.Node)
    picLayer: cc.Node = null;

    onLoad() {
        cc.systemEvent.setAccelerometerEnabled(true);
    }

    //向量角度
    getVecDegree(dirVec: cc.Vec2, comVec: cc.Vec2): number {
        if (dirVec.equals(cc.v2(0, 0))) return 0;
        let radian: number = dirVec.signAngle(comVec);    // 求方向向量与对比向量间的弧度
        let degree: number = cc.misc.radiansToDegrees(radian);    // 将弧度转换为角度
        return degree;
    }

    picLayerFaceToCam() {
        let _quat = cc.quat();
        let _euler = cc.v3();
        let _vector2cam = cc.v2();
        let _posPic = cc.v2();
        var _degree = 0;
        for (var i in this.picLayer.children) {
            _posPic.x = this.picLayer.children[i].position.x;
            _posPic.y = this.picLayer.children[i].position.z;
            _vector2cam = _posPic.sub(cc.Vec2.ZERO);
            _degree = this.getVecDegree(_vector2cam, cc.v2(0, -1));
            _euler = cc.v3(0, _degree, 0);
            this.picLayer.children[i].setRotation(_quat.fromEuler(_euler));
        }
    }

    update() {
        this.picLayerFaceToCam();
        if (cc.sys.os != cc.sys.OS_ANDROID) return;
        let motionData = jsb.device.getDeviceMotionValue()
        let _orientationX = motionData[9]
        let _orientationY = motionData[10]
        let _orientationZ = motionData[11]
        _orientationY = -(_orientationY + 90)
        _orientationX = -_orientationX
        let _euler = cc.v3(_orientationY, _orientationX, _orientationZ);
        this.allSeeCam.node.setRotation(cc.quat().fromEuler(_euler));
    }
}
