const { ccclass, property } = cc._decorator;

@ccclass
export default class touchLayer extends cc.Component {

    @property(cc.Camera)
    allSeeCamera: cc.Camera = null;

    onLoad() {   
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
    }

    onTouchMove(event) {
        let _quat = cc.quat();
        let _euler = cc.v3();
        this.allSeeCamera.node.getRotation(_quat);
        _quat.toEuler(_euler);
        var _addDigreeY = -event.getDeltaX() * (Math.PI / 180) * 10;
        var _addDigreeX = event.getDeltaY() * (Math.PI / 180) * 10;
        _euler.x += _addDigreeX;
        _euler.y += _addDigreeY;
        _euler.z = 0;
        this.allSeeCamera.node.setRotation(_quat.fromEuler(_euler));
    }

    showDebug() {
        // var _camRotationQuat = cc.quat();
        // var _camRotationEuler = cc.v3();
        // this.allSeeCamera.node.getRotation(_camRotationQuat);
        // _camRotationQuat.toEuler(_camRotationEuler);
        // this.camRotationLabelList[0].string = "x:" + _camRotationEuler.x.toFixed(2);
        // this.camRotationLabelList[1].string = "y:" + _camRotationEuler.y.toFixed(2);
        // this.camRotationLabelList[2].string = "z:" + _camRotationEuler.z.toFixed(2);

        // this.accLabelList[0].string = "accX:" + this._motion.x.toFixed(2);
        // this.accLabelList[1].string = "accY:" + this._motion.y.toFixed(2);
        // this.accLabelList[2].string = "accZ:" + this._motion.z.toFixed(2);

        // cc.log(this._motion.x, this._motion.y, this._motion.z);
    }
}
