"use strict";
cc._RF.push(module, '3278fbm3O5Om5pCAWmy84AM', 'bullet');
// Script/bullet.js

"use strict";

/**
 * 子弹处理类
 */
cc.Class({
    extends: cc.Component,

    properties: {},
    ctor: function ctor() {
        this.speed = 30; //子弹的速度
        this.isLock = false; //是否锁定update方法 保证全局变量只赋值一次
        this.bulletRadian = null; //本子弹的弧度 由全局变量赋值
    },

    // onLoad () {},

    start: function start() {},
    update: function update(dt) {
        //if 方法保证在update循环过程中  全局弧度只会赋值给本地弧度一次 防止子弹飞射的过程中 全局弧度变化 子弹也跟着变 
        //但是无效  只要赋值一次  以后全局弧度 变化 本地子弹弧度也会同步变化

        if (!this.isLock) {
            this.isLock = true;
            this.bulletRadian = cc.v2(globalRadian);
        }
        var dist = this.speed * dt;
        var vx = dist * this.bulletRadian.x;
        var vy = dist * this.bulletRadian.y;
        this.node.x += vx;
        this.node.y += vy;
    }
});

cc._RF.pop();