(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/joystick.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'e3838SJJmtFzpvkXOEl4SUV', 'joystick', __filename);
// Script/joystick.js

"use strict";

cc.Class({
    extends: cc.Component,

    properties: {
        handShank: cc.Node
    },

    ctor: function ctor() {
        this.Max_R = 100; //手柄最大移动半径
        this.dir = cc.v2(0, 0);
        this.speed1 = 400;
    },


    // onLoad () {},

    start: function start() {
        this.handShank.on(cc.Node.EventType.TOUCH_START, function (e) {
            this.handShank.setPosition(cc.v2(0, 0));
            globalRadian = cc.v2(0, 0);
        }, this);

        this.handShank.on(cc.Node.EventType.TOUCH_MOVE, function (e) {
            var selfPos = e.getLocation();
            var this_Node_Pos = this.node.convertToNodeSpaceAR(selfPos);
            var len = this_Node_Pos.mag();
            var dir = cc.v2(0, 0);
            //赋值给全局弧度 用来设置子弹发射角度  赋值的是弧度值 不是坐标
            dir.x = this_Node_Pos.x / len; //cosA
            dir.y = this_Node_Pos.y / len; // sin
            globalRadian = dir;
            if (len >= this.Max_R) {
                this_Node_Pos.x = this_Node_Pos.x / len * this.Max_R;
                this_Node_Pos.y = this_Node_Pos.y / len * this.Max_R;
            }
            this.handShank.setPosition(this_Node_Pos);
        }, this);

        this.handShank.on(cc.Node.EventType.TOUCH_END, function (e) {
            this.handShank.setPosition(cc.v2(0, 0));
            globalRadian = cc.v2(0, 0);
        }, this);

        this.handShank.on(cc.Node.EventType.TOUCH_CANCEL, function (e) {
            this.handShank.setPosition(cc.v2(0, 0));
            globalRadian = cc.v2(0, 0);
        }, this);
    },
    update: function update(dt) {}
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=joystick.js.map
        