

enum ShopType {
    Plane = 0,
    Bullet = 1,
}

const confs = {
    0:13,
    1:28,
}

const {ccclass, property} = cc._decorator;

@ccclass
export default class ShopPanel extends cc.Component {
	
    @property(cc.ToggleContainer)
    private pageToggleContainer:cc.ToggleContainer = null;

    @property(cc.Node)
    private content:cc.Node = null;

    @property(cc.Prefab)
    itemPre:cc.Prefab = null;

    
    private itemNodePool:cc.NodePool;

    onLoad(){
        this.itemNodePool = new cc.NodePool();
    }

    private _shopSelectTag : ShopType;
    public get shopSelectTag() : ShopType {
        return this._shopSelectTag;
    }
    public set shopSelectTag(v : ShopType) {
        this._shopSelectTag = v;
        cc.sys.localStorage.setItem("shopSelectTag", this._shopSelectTag);
    }
    
    private invalid(parmas){
        return "undefined" == typeof parmas || null == parmas || "" == parmas;
    }

    onEnable(){
        let _shopSelectTag = cc.sys.localStorage.getItem("shopSelectTag");
        this._shopSelectTag = (!this.invalid(_shopSelectTag) && _shopSelectTag <= ShopType.Bullet) ? _shopSelectTag : ShopType.Plane;

        if (ShopType.Plane == this.shopSelectTag) {
            this.toggleTo(ShopType.Plane);
        }else{
            this.pageToggleContainer.toggleItems[this.shopSelectTag].isChecked = true;
        }

        //如果延迟一帧就不会出现问题
        // this.scheduleOnce(()=>{
        //     if (ShopType.Plane == this.shopSelectTag) {
        //         this.toggleTo(ShopType.Plane);
        //     }else{
        //         this.pageToggleContainer.toggleItems[this.shopSelectTag].isChecked = true;
        //     }
        // })
    }

    private onToggle(toggle:cc.Toggle, customData:string){
        console.log("onToggle", customData, toggle);
        if (ShopType[ShopType.Bullet].toLowerCase() == customData) {
            this.toggleTo(ShopType.Bullet);
        }else if(ShopType[ShopType.Plane].toLowerCase() == customData){
            this.toggleTo(ShopType.Plane);
        }
    }

    private toggleTo(shopType:ShopType){
        this.shopSelectTag = shopType;
        console.log("this.content.height1    ", this.content.height, this.content.childrenCount)
        this.recycleAllItem();
        console.log("this.content.height2    ", this.content.height, this.content.childrenCount)

        let length = 0;
        if (this.itemNodePool.size() >= confs[shopType]) {
            length = confs[shopType];
        }else{
            length = this.itemNodePool.size();
        }

        for (let i = 0; i < length; i++) {
            let item = this.itemNodePool.get();
            item.parent = this.content;
        }

        for (let j = length; j < confs[shopType]; j++) {
            const item = <cc.Node>cc.instantiate(this.itemPre);
            item.parent = this.content;
        }
        console.log("this.content.height3    ", this.content.height, this.content.childrenCount)
    }

    private recycleAllItem(){
        let children:Array<cc.Node> = this.content.children;

        for (let i = children.length - 1; i >= 0; i--) {
            const child = children[i];
            child.parent = null;
            this.itemNodePool.put(child);
        }

        this.content.height = 1;
    }

}
