

/**
 * Bug现象：Scrollview顶部和底部出现多余的空白 必现
 * Bug出现情况步骤：
 * 1、切换到Bullet页签
 * 2、切换到Plane页签
 * 3、关闭页面
 * 4、打开页面 这时候条目少的就会出现 Scrollview顶部和底部出现多余的空白 情况
 */

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {	
    
    @property(cc.Button)
    private openBtn:cc.Button = null;
    
    @property(cc.Button)
    private closeBtn:cc.Button = null;

    @property(cc.Prefab)
    private shopPanelPre:cc.Prefab = null;

    private shopPanel:cc.Node = null;
    
    onLoad(){
        this.closeBtn.interactable = false;
    }

    onOpenBtnClick(){
        this.openBtn.interactable = false;
        this.closeBtn.interactable = true;

        if (null == this.shopPanel) {
            console.log("实例化商店面板");
            this.shopPanel = <cc.Node>cc.instantiate(this.shopPanelPre);
        }

        this.openPanel(this.shopPanel);
        // this.shopPanel.once("Close", ()=>{
        //     this.closePanel(this.shopPanel);
        // })
    }

    onCloseBtnClick(){
        this.openBtn.interactable = true;
        this.closeBtn.interactable = false;
        if (null != this.shopPanel && this.shopPanel.isValid) {
            this.closePanel(this.shopPanel);
        }
    }

    
    /**
     * 打开面板
     * @param target 面板节点
     */
    private openPanel(target:cc.Node){
        if (target.getNumberOfRunningActions() > 0 || target.hasEventListener("Close")) {
            console.log("上一个面板没有关闭，不在重新打开面板", target);
            return;            
        }

        target.runAction(cc.sequence(
            cc.spawn(cc.fadeIn(0.3),cc.scaleTo(0.3, 1.1).easing(cc.easeSineIn())),
            cc.scaleTo(0.3, 1)
        ));

        target.parent = cc.find("Canvas");
    }

    private closePanel(target:cc.Node){
        if (target.getNumberOfRunningActions() > 0) {
            console.log("上一个面板正在关闭，不在重新关闭面板", target);
            return;            
        }
        target.runAction(cc.sequence(
            cc.spawn(
                cc.fadeOut(0.3),
                cc.scaleTo(0.3, 0).easing(cc.easeSineInOut())
            ),            
            cc.removeSelf(),
        ))
    }
}
