"use strict";
cc._RF.push(module, '4076dOzkwBJOZw6xWwODTgl', 'Test2');
// Test2.ts

/**
 * Bug现象：Scrollview顶部和底部出现多余的空白 必现
 * Bug出现情况步骤：
 * 1、切换到Bullet页签
 * 2、切换到Plane页签
 * 3、关闭页面
 * 4、打开页面 这时候条目少的就会出现 Scrollview顶部和底部出现多余的空白 情况
 */
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var NewClass = /** @class */ (function (_super) {
    __extends(NewClass, _super);
    function NewClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.openBtn = null;
        _this.closeBtn = null;
        _this.shopPanelPre = null;
        _this.shopPanel = null;
        return _this;
    }
    NewClass.prototype.onLoad = function () {
        this.closeBtn.interactable = false;
    };
    NewClass.prototype.onOpenBtnClick = function () {
        this.openBtn.interactable = false;
        this.closeBtn.interactable = true;
        if (null == this.shopPanel) {
            console.log("实例化商店面板");
            this.shopPanel = cc.instantiate(this.shopPanelPre);
        }
        this.openPanel(this.shopPanel);
        // this.shopPanel.once("Close", ()=>{
        //     this.closePanel(this.shopPanel);
        // })
    };
    NewClass.prototype.onCloseBtnClick = function () {
        this.openBtn.interactable = true;
        this.closeBtn.interactable = false;
        if (null != this.shopPanel && this.shopPanel.isValid) {
            this.closePanel(this.shopPanel);
        }
    };
    /**
     * 打开面板
     * @param target 面板节点
     */
    NewClass.prototype.openPanel = function (target) {
        if (target.getNumberOfRunningActions() > 0 || target.hasEventListener("Close")) {
            console.log("上一个面板没有关闭，不在重新打开面板", target);
            return;
        }
        target.runAction(cc.sequence(cc.spawn(cc.fadeIn(0.3), cc.scaleTo(0.3, 1.1).easing(cc.easeSineIn())), cc.scaleTo(0.3, 1)));
        target.parent = cc.find("Canvas");
    };
    NewClass.prototype.closePanel = function (target) {
        if (target.getNumberOfRunningActions() > 0) {
            console.log("上一个面板正在关闭，不在重新关闭面板", target);
            return;
        }
        target.runAction(cc.sequence(cc.spawn(cc.fadeOut(0.3), cc.scaleTo(0.3, 0).easing(cc.easeSineInOut())), cc.removeSelf()));
    };
    __decorate([
        property(cc.Button)
    ], NewClass.prototype, "openBtn", void 0);
    __decorate([
        property(cc.Button)
    ], NewClass.prototype, "closeBtn", void 0);
    __decorate([
        property(cc.Prefab)
    ], NewClass.prototype, "shopPanelPre", void 0);
    NewClass = __decorate([
        ccclass
    ], NewClass);
    return NewClass;
}(cc.Component));
exports.default = NewClass;

cc._RF.pop();