(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/ShopPanel.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '35546/TAXdPJpe+uPe75j0E', 'ShopPanel', __filename);
// ShopPanel.ts

Object.defineProperty(exports, "__esModule", { value: true });
var ShopType;
(function (ShopType) {
    ShopType[ShopType["Plane"] = 0] = "Plane";
    ShopType[ShopType["Bullet"] = 1] = "Bullet";
})(ShopType || (ShopType = {}));
var confs = {
    0: 13,
    1: 28,
};
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var ShopPanel = /** @class */ (function (_super) {
    __extends(ShopPanel, _super);
    function ShopPanel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.pageToggleContainer = null;
        _this.content = null;
        _this.itemPre = null;
        return _this;
    }
    ShopPanel.prototype.onLoad = function () {
        this.itemNodePool = new cc.NodePool();
    };
    Object.defineProperty(ShopPanel.prototype, "shopSelectTag", {
        get: function () {
            return this._shopSelectTag;
        },
        set: function (v) {
            this._shopSelectTag = v;
            cc.sys.localStorage.setItem("shopSelectTag", this._shopSelectTag);
        },
        enumerable: true,
        configurable: true
    });
    ShopPanel.prototype.invalid = function (parmas) {
        return "undefined" == typeof parmas || null == parmas || "" == parmas;
    };
    ShopPanel.prototype.onEnable = function () {
        var _shopSelectTag = cc.sys.localStorage.getItem("shopSelectTag");
        this._shopSelectTag = (!this.invalid(_shopSelectTag) && _shopSelectTag <= ShopType.Bullet) ? _shopSelectTag : ShopType.Plane;
        if (ShopType.Plane == this.shopSelectTag) {
            this.toggleTo(ShopType.Plane);
        }
        else {
            this.pageToggleContainer.toggleItems[this.shopSelectTag].isChecked = true;
        }
        //如果延迟一帧就不会出现问题
        // this.scheduleOnce(()=>{
        //     if (ShopType.Plane == this.shopSelectTag) {
        //         this.toggleTo(ShopType.Plane);
        //     }else{
        //         this.pageToggleContainer.toggleItems[this.shopSelectTag].isChecked = true;
        //     }
        // })
    };
    ShopPanel.prototype.onToggle = function (toggle, customData) {
        console.log("onToggle", customData, toggle);
        if (ShopType[ShopType.Bullet].toLowerCase() == customData) {
            this.toggleTo(ShopType.Bullet);
        }
        else if (ShopType[ShopType.Plane].toLowerCase() == customData) {
            this.toggleTo(ShopType.Plane);
        }
    };
    ShopPanel.prototype.toggleTo = function (shopType) {
        this.shopSelectTag = shopType;
        console.log("this.content.height1    ", this.content.height, this.content.childrenCount);
        this.recycleAllItem();
        console.log("this.content.height2    ", this.content.height, this.content.childrenCount);
        var length = 0;
        if (this.itemNodePool.size() >= confs[shopType]) {
            length = confs[shopType];
        }
        else {
            length = this.itemNodePool.size();
        }
        for (var i = 0; i < length; i++) {
            var item = this.itemNodePool.get();
            item.parent = this.content;
        }
        for (var j = length; j < confs[shopType]; j++) {
            var item = cc.instantiate(this.itemPre);
            item.parent = this.content;
        }
        console.log("this.content.height3    ", this.content.height, this.content.childrenCount);
    };
    ShopPanel.prototype.recycleAllItem = function () {
        var children = this.content.children;
        for (var i = children.length - 1; i >= 0; i--) {
            var child = children[i];
            child.parent = null;
            this.itemNodePool.put(child);
        }
        this.content.height = 1;
    };
    __decorate([
        property(cc.ToggleContainer)
    ], ShopPanel.prototype, "pageToggleContainer", void 0);
    __decorate([
        property(cc.Node)
    ], ShopPanel.prototype, "content", void 0);
    __decorate([
        property(cc.Prefab)
    ], ShopPanel.prototype, "itemPre", void 0);
    ShopPanel = __decorate([
        ccclass
    ], ShopPanel);
    return ShopPanel;
}(cc.Component));
exports.default = ShopPanel;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=ShopPanel.js.map
        