// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
var tools = require("tools")
var pool_mgr = require("pool_mgr");
cc.Class({
    extends: cc.Component,

    properties: {
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        this.texture = null;
        this.gameScript = cc.find("UI_ROOT").getComponent("game");
        this.winSizWidth = cc.winSize.width;
        this.updateIndex = 0;
    },

    start() {
        this.propFabs = {};
        Object.keys(cc.vv.propPrefabs).forEach(function(key){
            this.propFabs["node_" + key] =  cc.vv.propPrefabs[key];
        }.bind(this));
        for (let i = 0; i < this.node.children.length; i++) {
            let nodeName = this.node.children[i].name;
            
            if (nodeName == "node_electric_first" || nodeName == "node_electric_second") {
                let prop = cc.instantiate(this.propFabs["node_electric_pillar"]);
                this.node.children[i].addChild(prop);
                if (nodeName == "node_electric_first") {
                    let electricProp = cc.instantiate(this.propFabs["node_h_electric"]);
                    this.node.children[i].addChild(electricProp);
                    let nextX = this.getNextElectricPillarPosX(i);
                    electricProp.scaleX = (nextX - this.node.children[i].x) / 320;
                }
            }
            else if (this.propFabs[nodeName] != null) {
                if (nodeName == "node_gold") {
                    let goldProp = pool_mgr.getGoldNode();
                    this.node.children[i].addChild(goldProp);
                    goldProp.getComponent("gold").setPool();
                }
                else if(cc.vv.gameDef.game_mode && nodeName == "node_boxRand")
                {

                }
                else {
                    let prop = cc.instantiate(this.propFabs[nodeName]);
                    this.node.children[i].addChild(prop);
                    if (nodeName.indexOf("stone") != -1) {
                        prop.getComponent("stone").setStoneType(nodeName);
                    }
                    else if (nodeName.indexOf("floor") != -1) {
                        let tiledMap = prop.getChildByName("anim").getChildByName("floor").getComponent(cc.TiledMap);
                        let tiledLayer = tiledMap.getLayer("tiledlayer");
                        tiledLayer.setTexture(this.texture);
                    }
                }
            }
        }

        // let node = new cc.Node();
        // let lable = node.addComponent(cc.Label);
        // lable.string = this.node.name;
        // this.node.addChild(node);
    },

    setMapTexture: function (texture, addBox) {
        if(addBox)
        {
            let box = cc.instantiate(cc.vv.propPrefabs["boxRand"]);
            this.node.addChild(box);
            box.y = 50;
            box.x = -tools.getRandomNumber(200, this.node.getChildByName("tiledlayer").width - 200)
        }
        if (texture != null) {
            this.texture = texture;
            var tiledMap = this.node.getComponent(cc.TiledMap);
            var tiledLayer = tiledMap.getLayer("tiledlayer");
            tiledLayer.setTexture(texture);
        }
    },

    getNextElectricPillarPosX: function(index)//获取下一根电柱的x坐标
    {
        for (let i = index; i < this.node.children.length; i++) {
            if(this.node.children[i].name == "node_electric_second")
            {
                return this.node.children[i].x;
            }
        }
        return 0;
    },

    update (dt) {
        this.updateIndex += dt;
        if(this.updateIndex < 0.5)
        {
            return;
        }
        else
        {
            this.updateIndex = 0;
        }
        for(let i = 0; i < this.node.children.length; i++)//优化，不在屏幕中的地图元素不渲染
        {
            
            if(this.node.children[i].name != "tiledlayer")
            {
                let wposx = this.node.convertToWorldSpaceAR(this.node.children[i].position);
                if(wposx < 100 || wposx > this.winSizWidth + 100)
                {
                    this.node.children[i].active = false;
                }
                else
                {
                    this.node.children[i].active = true;
                }
            }
        }
    },
});
