// Learn cc.Class:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://docs.cocos2d-x.org/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] https://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

var pool_mgr = {
    createNewGold: false,
    init: function()
    {
        this.createPlayerPool();
        this.createGoldPool();
        this.createChickenPool();
        this.createAirChickenPool();
        this.createBoomPool();
        this.createAirBoomPool();
        this.createTreePool();
        this.createPigPool();
        this.createAirPigPool();
    },

    clearPool: function()
    {
        this.playerPool.clear();
        this.goldPool.clear();
        this.chickenPool.clear();
        this.airChickenPool.clear();
        this.boomPool.clear();
        this.airBoomPool.clear();
        this.treePool.clear();
        this.pigPool.clear();
        this.airPigPool.clear();
    },
    //人物spine
    createPlayerPool: function(){
        this.playerPool = new cc.NodePool("playerPool");
        for(let i = 0; i < 5; i++)
        {
            let playerNode = cc.instantiate(cc.vv.poolPrefabs["playerSpine"]);
            this.playerPool.put(playerNode);
        }
    },

    getPlayerNode: function(){
        if(this.playerPool.size() <= 0)
        {
            let playerNode = cc.instantiate(cc.vv.poolPrefabs["playerSpine"]);
            this.playerPool.put(playerNode);
        }
        return this.playerPool.get();
    },

    recoverPlayerNode: function(node)
    {
        this.playerPool.put(node)
    },


    //金币
    createGoldPool: function(){
        this.goldPool = new cc.NodePool();
    },

    getGoldNode: function(){
        if(this.goldPool.size() <= 0)
        {
            this.createNewGold = true;
            let addprop = cc.instantiate(cc.vv.propPrefabs["gold"]);
            this.goldPool.put(addprop);
        }
        else
        {
            this.createNewGold = false;
        }
        return this.goldPool.get();
    },

    recoverGoldNode: function(node)
    {
        this.goldPool.put(node)
    },

    //地上的鸡
    createChickenPool: function(){
        this.chickenPool = new cc.NodePool();
    },

    getChickenNode: function(){
        if(this.chickenPool.size() <= 0)
        {
            let prop = cc.instantiate(cc.vv.poolPrefabs["chickenPool"]);
            this.chickenPool.put(prop);
        }
        return this.chickenPool.get();
    },

    recoverChickenNode: function(node)
    {
        this.chickenPool.put(node)
    },

    //空中的鸡
    createAirChickenPool: function(){
        this.airChickenPool = new cc.NodePool();
    },

    getAirChickenNode: function(){
        if(this.airChickenPool.size() <= 0)
        {
            let addprop = cc.instantiate(cc.vv.poolPrefabs["airChickenPool"]);
            this.airChickenPool.put(addprop);
        }
        return this.airChickenPool.get();
    },

    recoverAirChickenNode: function(node)
    {
        this.airChickenPool.put(node)
    },

    //地面炸弹
    createBoomPool: function(){
        this.boomPool = new cc.NodePool("boomPool");
    },

    getBoomNode: function(){
        if(this.boomPool.size() <= 0)
        {
            let addprop = cc.instantiate(cc.vv.poolPrefabs["boomPool"]);
            this.boomPool.put(addprop);
        }
        return this.boomPool.get();
    },

    recoverBoomNode: function(node)
    {
        this.boomPool.put(node)
    },

    //空中炸弹
    createAirBoomPool: function(){
        this.airBoomPool = new cc.NodePool("boomPool");
    },

    getAirBoomNode: function(){
        if(this.airBoomPool.size() <= 0)
        {
            let addprop = cc.instantiate(cc.vv.poolPrefabs["airBoomPool"]);
            this.airBoomPool.put(addprop);
        }
        return this.airBoomPool.get();
    },

    recoverAirBoomNode: function(node)
    {
        this.airBoomPool.put(node)
    },

    //空中导弹
    createAirPigPool: function(){
        this.airPigPool = new cc.NodePool();
    },

    getAirPigNode: function(){
        if(this.airPigPool.size() <= 0)
        {
            let addprop = cc.instantiate(cc.vv.poolPrefabs["airPigPool"]);
            this.airPigPool.put(addprop);
        }
        return this.airPigPool.get();
    },

    recoverAirPigNode: function(node)
    {
        this.airPigPool.put(node)
    },

     //猪
    createPigPool: function(){
        this.pigPool = new cc.NodePool();
    },

    getPigNode: function(){
        if(this.pigPool.size() <= 0)
        {
            let addprop = cc.instantiate(cc.vv.poolPrefabs["pigPool"]);
            this.pigPool.put(addprop);
        }
        return this.pigPool.get();
    },

    recoverPigNode: function(node)
    {
        this.pigPool.put(node)
    },

    //背景树
    createTreePool: function(){
        this.treePool = new cc.NodePool("tree");
    },

    getTreeNode: function(){
        if(this.treePool.size() <= 0)
        {
            let addprop = cc.instantiate(cc.vv.poolPrefabs["tree"]);
            this.treePool.put(addprop);
        }
        return this.treePool.get();
    },

    recoverTreeNode: function(node)
    {
        this.treePool.put(node)
    },
}

module.exports = pool_mgr;